<?php
/**
 * @version		$Id: joomla.php 10709 2008-08-21 09:58:52Z eddieajau $
 * @package		Joomla
 * @subpackage	JFramework
 * @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access') ;

jimport('joomla.plugin.plugin') ;

/**
 * Joomla Authentication plugin
 *
 * @package		Joomla
 * @subpackage	JFramework
 * @since 1.5
 */
class plgAuthenticationOseahauth extends JPlugin
{

    /**
     * Constructor
     *
     * For php4 compatability we must not use the __constructor as a constructor for plugins
     * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
     * This causes problems with cross-referencing necessary for the observer design pattern.
     *
     * @param object $subject The object to observe
     * @param array  $config  An array that holds the plugin configuration
     * @since 1.5
     */
    function plgAuthenticationOseahauth(&$subject, $config)
    {
        parent::__construct($subject, $config) ;
    }


    /** Get IP **/
    function getRealIpAddr()
    {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) //check ip from share internet

        {
            $ip = $_SERVER['HTTP_CLIENT_IP'] ;
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
        //to check ip is pass from proxy

        {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'] ;
        } else
        {
            $ip = $_SERVER['REMOTE_ADDR'] ;
        }
        return $ip ;
    }

    /**
     * This method should handle any authentication and report back to the subject
     *
     * @access	public
     * @param   array 	$credentials Array holding the user credentials
     * @param 	array   $options     Array of extra options
     * @param	object	$response	 Authentication response object
     * @return	boolean
     * @since 1.5
     */
    function onAuthenticate($credentials, $options, &$response)
    {
        jimport('joomla.user.helper') ;

        $plugin = &JPluginHelper::getPlugin('authentication', 'oseahauth') ;
        $params = new JParameter($plugin->params) ;
        $maxattempts = $params->get('maxattempts') ;
        if (empty($maxattempts))
        {$maxattempts=3;}
        $intAntihacker = $params->get('intAntihacker') ;
        $ip = $this->getRealIpAddr() ;
        
        // Joomla does not like blank passwords
        if (empty($credentials['password']))
        {
            $response->status = JAUTHENTICATE_STATUS_FAILURE ;
            $response->error_message = 'Empty password not allowed' ;
            return false ;
        }

        // Initialize variables
        $conditions = '' ;

        // Get a database object
        $db = &JFactory::getDBO() ;
 
        $query = 'SELECT `id`, `password`, `gid`' . ' FROM `#__users`' .
            ' WHERE username=' . $db->Quote($credentials['username']) ;
        $db->setQuery($query) ;
        $result = $db->loadObject() ;


        if ($result)
        {
            $parts = explode(':', $result->password) ;
            $crypt = $parts[0] ;
            $salt = @$parts[1] ;
            $testcrypt = JUserHelper::getCryptedPassword($credentials['password'], $salt) ;

            if ($crypt == $testcrypt)
            {
                $user = JUser::getInstance($result->id) ; // Bring this in line with the rest of the system
                $response->email = $user->email ;
                $response->fullname = $user->name ;
                $response->status = JAUTHENTICATE_STATUS_SUCCESS ;
                $response->error_message = '' ;
                if (isset($_SESSION['attempts']))
                {
                    unset($_SESSION['attempts']) ;
                }

                

                if ($result->gid == '23' || $result->gid == '24' || $result->gid == '25')
                {   
                	if ($intAntihacker==true)
                	{
                	$query = "SELECT * FROM `#__anti_hacker_iptable` WHERE ip = '" . $ip . "'" ;
                    $db->setQuery($query) ;
                    $result2 = $db->loadObject() ;
                    
					if (!empty($result2))
					{
					$query = "DELETE FROM `#__anti_hacker_iptable` WHERE ip = '" . $ip . "'" ;
                    $db->setQuery($query) ;
                    $db->query() ;
                    }
                    }
                }


            } else
            {   
                if (!isset($_SESSION['attempts']))
                {
                    $_SESSION['attempts'] = 0 ;
                }
                $_SESSION['attempts']++ ;
                $chance = $maxattempts - $_SESSION['attempts'] ;

                if ($_SESSION['attempts'] < $maxattempts)
                {
                    $response->status = JAUTHENTICATE_STATUS_FAILURE ;
                    $response->error_message = 'Invalid username and password' ;
                    echo '<dl id="system-message">
                       <dd class="error message fade">
						<ul>
						<li>Invalid username and password. Please check your password again. You still have ' .
                        $chance . ' chances left.</li>
						</ul>
						</dd>
						</dl>' ;
                } else
                {
                    $response->status = JAUTHENTICATE_STATUS_FAILURE ;
                    $response->error_message = 'User does not exist' ;

                    if ($result->gid == '23' || $result->gid == '24' || $result->gid == '25')
                    {
                        $query = "UPDATE #__users SET `block` = '1' WHERE #__users.`id` =" . $result->
                            id . " LIMIT 1 ;" ;
                        $db->setQuery($query) ;
                        $db->query() ;

                        echo '<dl id="system-message">
                       <dd class="error message fade">
						<ul>
						<li>Your Account Has Been Blocked For Security Reasons. Please Contact Your Webmaster to Reactivate your account.</li>
						</ul>
						</dd>
						</dl>' ;
					
					if ($intAntihacker==true)
                	{
                	$query = "SELECT * FROM `#__anti_hacker_iptable` WHERE ip = '" . $ip . "'" ;
                    $db->setQuery($query) ;
                    $result3 = $db->loadObject() ;
					
					if (!empty($result3))
					{	
                	$query = "UPDATE `#__anti_hacker_iptable` SET `banned` = '1' WHERE ip = '" . $ip . "'" ;
                    $db->setQuery($query) ;
                    $db->query() ;
                    }
                    else
                    {
                    $today = date("Y-m-d h:i:s");
                    $referer = JURI::root()."/administrator/"; 
                    $query = "INSERT INTO `#__anti_hacker_iptable` (`id` , `ip` , `string` , `violation` , `target` ,`banned` , `datetime` , `referer` )
VALUES (
NULL , '" . $ip . "', 'None', 'Failed Login Attempt', 'none', '1', '".$today."', '".$referer."')";
                    $db->setQuery($query) ;
                    $db->query() ;	
                    }
                    }	
				 }
                }

            }
        } else
        {
            $response->status = JAUTHENTICATE_STATUS_FAILURE ;
            $response->error_message = 'User does not exist' ;
        }
    }
}
