<?php
/**
  * @version     3.0 +
  * @package       Open Source Excellence Security Suite
  * @subpackage    Open Source Excellence CPU
  * @author        Open Source Excellence {@link http://www.opensource-excellence.com}
  * @author        Created on 30-Sep-2010
  * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
  *
  *
  *  This program is free software: you can redistribute it and/or modify
  *  it under the terms of the GNU General Public License as published by
  *  the Free Software Foundation, either version 3 of the License, or
  *  (at your option) any later version.
  *
  *  This program is distributed in the hope that it will be useful,
  *  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *  GNU General Public License for more details.
  *
  *  You should have received a copy of the GNU General Public License
  *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  *  @Copyright Copyright (C) 2008 - 2010- ... Open Source Excellence
*/
if(!defined('_JEXEC') && !defined('OSE_ADMINPATH'))
{
	die("Direct Access Not Allowed");
}
class oseVirusscan
{
	var $file= null;
	var $virus_store= null;
	function __construct()
	{
		$instance= self :: getInstanceByVersion();
		return $instance;
	}
	function getInstance()
	{
		$instance= self :: getInstanceByVersion();
		return $instance;
	}
	public static function getInstanceByVersion()
	{
		static $instance;
		if(!empty($instance))
		{
			return $instance;
		}
		if(class_exists('SConfig'))
		{
			if(!defined('DS'))
			{
				define('DS', DIRECTORY_SEPARATOR);
			}
			require_once(dirname(__FILE__).DS.'j15'.DS.'j15.php');
			$instance= new oseVirusscan_J15();
		}
		else
		{
			jimport('joomla.version');
			$version= new JVersion();
			$version= substr($version->getShortVersion(), 0, 3);
			if($version == '1.5')
			{
				require_once(dirname(__FILE__).DS.'j15'.DS.'j15.php');
				$instance= new oseVirusscan_J15();
			}
			else
			{
				require_once(dirname(__FILE__).DS.'j16'.DS.'j16.php');
				$instance= new oseVirusscan_J16();
			}
		}
		return $instance;
	}
	function __toString()
	{
		return get_class($this);
	}
	function fileClean($file)
	{
		$exps= self :: getPatternExp();
		// get content
		$content= JFile :: read($file);
		// loop for search string
		$result= false;
		foreach($exps['type2'] as $pattern)
		{
			if(preg_match($pattern[1], $content))
			{
				$content= preg_replace($pattern[1], "", $content);
				chmod($file, 0777);
				if(JFile :: write($file, $content))
				{
					$result= true;
				}
				chmod($file, 0644);
			}
		}
		return $result;
	}
	function virusScan($file)
	{
		return null;
	}
	function quarantine($file)
	{
		return null;
	}
	function restore($file, $path)
	{
		return null;
	}
	function getPatternExp()
	{
		static $defVirus;
		$curDir= dirname(__FILE__);
		require_once($curDir.DS.'libraries'.DS.'assets'.DS.'ose_virus_definitions.php');
		$oseVirusDefinitions= new oseVirusDefinitions();
		$oseVirusDefinitions->setPatterns();
		$defVirus['type2']= $oseVirusDefinitions->patterns;
		if(empty($defVirus))
		{
			return array();
		}
		else
		{
			return $defVirus;
		}
	}
	function getDefs()
	{
		static $defVirus;
		$curDir= dirname(__FILE__);
		require_once($curDir.DS.'libraries'.DS.'assets'.DS.'ose_virus_definitions.php');
		$oseVirusDefinitions= new oseVirusDefinitions();
		$oseVirusDefinitions->setSignatures();
		$defVirus['type1']= $oseVirusDefinitions->signatures;
		if(empty($defVirus))
		{
			return array();
		}
		else
		{
			return $defVirus;
		}
	}
	public static function getScanExt()
	{
		return null;
	}
	function filter()
	{
		return;
	}
	function getWhiteList()
	{
		return;
	}
}