<?php

if(!class_exists('GKImageShowStyle3')){
	
	class GKImageShowStyle3
	{
		var $ID;
		var $config;
		var $path;
		var $settings;
		var $slides;
		
		function GKImageShowStyle3(	$module_id, $settings, $base_path, $group_settings, $slide_data )
		{
			$this->ID = $module_id;
			$this->path = $base_path;
			$this->settings = $group_settings;
			$this->slides = $slide_data;
			//
			$this->parse($settings);
			$this->generate();
		}
		
		function parse($settings)
		{
			// creating configuration array (hash)
			$this->config = array(
										"image_rows" => 3,
										"image_cols" => 3,
										"image_margin" => "0 0 0 0",
										"image_padding" => "0 0 0 0",
										"image_border" => "",
										"slide_popups" => "true", // true | false
										"overlay" => "true", // true | false
										"show_text_block" => "true", // true|false
										"text_block_height" => 100,
										"clean_xhtml" => "true", // true |false
										"readmore_button" => "true", // true |false
										"title" => "true", // true |false
										"title_link" => "true", // true |false
										"text" => "true", // true | false
										"title_charcount" => 30,
										"text_wordcount" => 30,
										"readmore_button" => "true", // true | false
										"readmore_text" => 'See details'
									);
			// exploding settings
			$settings = preg_replace("/\n$/", '', $settings);
			$exploded_settings = explode(';', $settings);
			// parsing
			for( $i = 0; $i < count($exploded_settings) - 1; $i++ )
			{
				// preparing pair key-value
				$pair = explode('=', trim($exploded_settings[$i]));
				// extracting key and value from pair	
				$key = $pair[0];
				$value = $pair[1];	
				// checking existing of key in config array
				if(isset($this->config[$key]))
				{
					// setting value for key
					$this->config[$key] = $value;
				}
			}	
		}
		
		function generate()
		{
			require(JModuleHelper::getLayoutPath('mod_gk_image_show', 'style3'.DS.'tmpl'.DS.'content'));
		}
	}
	
}

if ( !function_exists('htmlspecialchars_decode') )
{
    function htmlspecialchars_decode($text)
    {
        return strtr($text, array_flip(get_html_translation_table(HTML_SPECIALCHARS)));
    }
}


?>