<?php
/**
* @package Joomla
* @subpackage Fabrik
* @copyright Copyright (C) 2005 Rob Clayburn. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport('joomla.application.component.view');

class FabrikViewTable extends JView{

	/**
	 * display a json object representing the table data.
	 */

	function display()
	{
		$model			= &$this->getModel();
		$model->setId(JRequest::getInt('tableid'));
		$table 			=& $model->getTable();
		$params 		=& $model->getParams();
		$model->render();
		$this->emptyDataMessage = $params->get('empty_data_msg');
		$rowid = JRequest::getInt('rowid');
		list($this->headings, $groupHeadings, $this->headingClass, $this->cellClass) = $this->get('Headings');
		$data =& $model->getData();
		$nav = $model->getPagination();
		$c = 0;
		$counter = 0;
		//comment this foreach loop out for page a day
		foreach ($data as $groupk => $group) {
				$last_pk = '';
				$last_i = 0;
				// $$$ rob 15/02/2011 seems like $i was not necessairily an autoincrementing value
				// well in fact the issue was when the data was joined and being merged we weren't
				// doing array_values() on the data to reset the keys.
				//However, the method below seems more robust and might be needed for grouped data (not tested
				// that yet with ajax reloading)

				//for ($i=0; $i<count($group); $i++) {
				foreach ($group as $i => $x) {
					$o = new stdClass();
					if (is_object($data[$groupk])) {
						$o->data = JArrayHelper::fromObject($data[$groupk]);
					} else {
						$o->data = $data[$groupk][$i];
					}

					$o->cursor = $i + $nav->limitstart;
					$o->total = $nav->total;
					$o->id = "table_".$table->id."_row_".@$o->data->__pk_val;
					$o->class = "fabrik_row oddRow".$c;
					if (is_object($data[$groupk])) {
						$data[$groupk] = $o;
					} else {
						$data[$groupk][$i] = $o;
					}
					$c = 1-$c;
					$counter++;
				}
		}

		if (strstr(JURI::base(), 'pageadaycalendar.com')) {
			//$d = is_array($data) ? $data[0] : $data;
			if (JRequest::getInt('tableid') == 8 || JRequest::getInt('tableid') == 16) {
				$purchaseList = new stdClass();
				$purchaseList->calendars = $data;
				$d = $purchaseList;
			}else{
				$d = $data;
			}
			echo json_encode($d);
			return;
		} else {
			$session =& JFactory::getSession();
			$d = array('id' => $table->id, 'rowid' => $rowid, 'model'=>'table', 'data'=>$data,
			'headings' => $this->headings,
			'formid'=> $model->getTable()->form_id,
			'lastInsertedRow' => $session->get('lastInsertedRow', 'test'));
			$d['nav'] = $nav->getPublicProperties();
			$d['htmlnav'] = $params->get('show-table-nav', 1) ? $nav->getListFooter($model->getId(), $this->getTmpl()) : '';
			$d['calculations'] = $model->getCalculations();
		}

		echo json_encode($d);
	}

	/**
	 * get the view template name
	 * @return string template name
	 */

	private function getTmpl()
	{
		$app =& JFactory::getApplication();
		$model =& $this->getModel();
		$table =& $model->getTable();
		$params =& $model->getParams();
		if ($app->isAdmin()) {
			$tmpl = $params->get('admin_template');
			if ($tmpl == -1 || $tmpl == '') {
				$tmpl = JRequest::getVar('layout', $table->template);
			}
		} else {
			$tmpl = JRequest::getVar('layout', $table->template);
		}
		return $tmpl;
	}
}
?>