<?php
/**
*
* @package fabrikar
* @author Rob Clayburn
* @copyright (C) Rob Clayburn
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/


// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

//require the abstract plugin class
require_once(COM_FABRIK_FRONTEND.DS.'models'.DS.'plugin.php');
require_once(COM_FABRIK_FRONTEND.DS.'models'.DS.'validation_rule.php');

class FabrikModelPhp extends FabrikModelValidationRule {

	var $_pluginName = 'php';

	/** @param string classname used for formatting error messages generated by plugin */
	var $_className = 'notempty php';

	/**
	 * validate the elements data against the rule
	 * @param string data to check
	 * @param object element
	 * @param int plugin sequence ref
	 * @param int repeat group count
	 * @return bol true if validation passes, false if fails
	 */

	function validate($data, &$element, $c, $repeat_count = 0)
	{
		//for multiselect elements
		if (is_array($data)) {
			$data = implode('', $data);
		}
		$params =& $this->getParams();
		$domatch = $params->get('php-match', '_default','array', $c);
		$domatch = $domatch[$c];
		if ($domatch) {
			$php_code = $params->get('php-code', '_default','array', $c);
			$php_code = @eval($php_code[$c]);
			FabrikWorker::logEval($php_code, 'Caught exception on eval in php validation::validate() : %s');
			return $php_code;
		}
		return true;
	}

	/**
	 *  renders admin settings
	 */

	function renderAdminSettings($elementId, &$row, &$params, $c)
	{
 		$params->_counter_override = $this->_counter;
 		$display =  ($this->_adminVisible) ? "display:block" : "display:none";
 		$return = '<div class="page-' . $elementId . ' validationSettings" style="' . $display . '">'
 		. $params->render('params', '_default', false, $c);
		$return .= '</div>';
 		$return = str_replace("\r", "", $return);
	  return $return;
	  //dont do here as if we json enocde it as we do in admin form view things go wrong
		//return  addslashes(str_replace("\n", "", $return));
 	}

 	/**
 	 * checks if the validation should replace the submitted element data
 	 * if so then the replaced data is returned otherwise original data returned
 	 * @param string original data
 	 * @param model $element
 	 * @param int $c validation plugin counter
 	 * @param int repeat group count
 	 * @return string original or replaced data
 	 */

 	function replace($data, &$element, $c, $repeat_count = 0)
 	{
 		$params =& $this->getParams();
		$domatch = $params->get('php-match', '_default','array', $c);
		$domatch = $domatch[$c];
		if (!$domatch) {
			$php_code = $params->get('php-code', '_default','array', $c);
			$php_code = @eval($php_code[$c]);
			FabrikWorker::logEval($php_code, 'Caught exception on eval in php validation::replace() : %s');
			return $php_code;
		}
		return $data;
 	}
}
?>