<?php

/**
 * @package Joomla
 * @subpackage Fabrik
 * @copyright Copyright (C) 2005 Rob Clayburn. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport('joomla.application.component.model');

require_once(COM_FABRIK_FRONTEND.DS.'models'.DS.'plugin.php');

class FabrikModelFormPlugin extends FabrikModelPlugin
{
	/**@var array formatted email data */
	var $emailData = null;

	/**
	 * run from table model when deleting rows
	 *
	 * @return bol
	 */

	function onDeleteRowsForm($pluginParams, $oRequest, $pluginArgs)
	{
		return true;
	}

	/**
	 * run right at the beginning of the form processing
	 *
	 * @return bool
	 */

	function onBeforeProcess()
	{
		return true;
	}

	/**
	 * run if form validation fails
	 *
	 * @return bool
	 */

	function onError()
	{

	}

	/**
	 * run before table calculations are applied
	 *
	 * @return bool
	 */

	function onBeforeCalculations()
	{
		return true;
	}

	/**
	 * run right at the end of the form processing
	 * form needs to be set to record in database for this to hook to be called
	 *
	 * @return bool
	 */

	function onAfterProcess()
	{
		return true;
	}

	/**
	 * alter the returned plugin manager's result
	 *
	 * @param string $method
	 * @return bool
	 */

	function customProcessResult($method )
	{
		return true;
	}

	/**
	 * sets up any bottom html
	 *
	 */

	function getBottomContent()
	{

	}

	/**
	 * get any html that needs to be written into the bottom of the form
	 *
	 * @return string html
	 */

	function getBottomContent_result()
	{
		return "";
	}

	/**
	 * sets up any top html
	 *
	 */

	function getTopContent()
	{

	}

	/**
	 * get any html that needs to be written into the top of the form
	 *
	 * @return string html
	 */

	function getTopContent_result()
	{
		return "";
	}

	/**
	 * show a new for entering the form actions options
	 */

	function renderAdminSettings($elementId, &$row, &$params, $lists, $c)
	{
		$params->_counter_override = $this->_counter;
		$display =  ($this->_adminVisible) ? "display:block" : "display:none";
		$return = '<div class="page-' . $elementId . ' elementSettings" style="' . $display . '">
 		'. $params->render('params', '_default', false, $c)
		.'</div>
 		';
		$return = str_replace("\r", "", $return);
		return $return;
		//dont do here as if we json enocde it as we do in admin form view things go wrong
		//return  addslashes(str_replace("\n", "", $return));
	}

	/**
	 * convert the posted form data to the data to be shown in the email
	 * e.g. radio buttons swap their values for the value's label
	 *
	 * HACKED from the form view
	 *
	 * @return array email data
	 */

	function getEmailData()
	{
		if (isset($this->emailData)) {
			return $this->emailData;
		}
		$model		=& $this->formModel;
		if (is_null($model->_formDataWithTableName)){
			return array();
		}
		$model->getPostMethod();
		//$$$rob don't render the form - there's no need and it gives a warning about an unfound rowid
		// $$$ rob also it sets teh fromModels rowid to an + int even if we are submitting a new form
		// which means that form plug-ins set to run on new only don't get triggered if they appear after
		// fabrikemail/fabrikreceipt
		//Now instead the pk value is taken from the tableModel->_lastInsertId and inserted at the end of this method
		//$model->render();

		$tableModel =& $model->_table;
		$table = is_object($tableModel) ? $tableModel->getTable() : null;

		$model->_editable = false;
		if (is_object($tableModel)) {
			$joins =& $tableModel->getJoins();
			$model->getJoinGroupIds($joins);
		}

		$params =& $model->getParams();

		$this->emailData = array();

		// $$$ hugh - temp foreach fix
		$groups = $model->getGroupsHiarachy();

		foreach ($groups as $gkey => $groupModel) {
			$groupParams 	=& $groupModel->getParams();
			//check if group is acutally a table join

			$repeatGroup = 1;
			$foreignKey = null;
			if ($groupModel->canRepeat()) {
				if ($groupModel->isJoin()) {

					$joinModel =& $groupModel->getJoinModel();
					$joinTable =& $joinModel->getJoin();
					$foreignKey  = '';
					if (is_object($joinTable)) {
						$foreignKey = $joinTable->table_join_key;
						//need to duplicate this perhaps per the number of times
						//that a repeat group occurs in the default data?
						//if (array_key_exists($joinTable->id, $model->_data['join'])) {
						if (array_key_exists($joinTable->id, $model->_formDataWithTableName['join'])) {

							$elementModels =& $groupModel->getPublishedElements();
							reset($elementModels);
							$tmpElement = current($elementModels);
							$smallerElHTMLName = $tmpElement->getFullName(false, true, false);
							//$repeatGroup = count($model->_data['join'][$joinTable->id][$smallerElHTMLName]);
							$repeatGroup = count($model->_formDataWithTableName['join'][$joinTable->id][$smallerElHTMLName]);
						} else {
							if (!$groupParams->get('repeat_group_show_first')) {
								continue;
							}
						}
					}
				} else {
					// repeat groups which arent joins
					$elementModels =& $groupModel->getPublishedElements();
					foreach ($elementModels as $tmpElement) {
						$smallerElHTMLName = $tmpElement->getFullName(false, true, false);
						if (is_array($model->_formDataWithTableName)) {
							if (array_key_exists($smallerElHTMLName."_raw", $model->_formDataWithTableName)) {
								$d = $model->_formDataWithTableName[$smallerElHTMLName."_raw"];
							} else {
								$d = @$model->_formDataWithTableName[$smallerElHTMLName];
							}
							if (is_string($d) && strstr($d, GROUPSPLITTER)) {
								$d = explode(GROUPSPLITTER, $d);
							}
							$c = count($d);
							if ($c > $repeatGroup) { $repeatGroup = $c;}
						}
					}
				}
			}
			$groupModel->_repeatTotal = $repeatGroup;
			$group =& $groupModel->getGroup();
			$aSubGroups = array();
			for ($c = 0; $c < $repeatGroup; $c++) {
				$aSubGroupElements = array();
				$elementModels =& $groupModel->getPublishedElements();

				foreach ($elementModels as $elementModel) {
					//force reload?
					$elementModel->defaults = null;
					$elementModel->_repeatGroupTotal = $repeatGroup - 1;
					$element =& $elementModel->getElement();

					$k			= $elementModel->getFullName(false, true, false);
					$key 				= $elementModel->getFullName(true, true, false);
					//used for working out if the element should behave as if it was
					//in a new form (joined grouped) even when editing a record
					$elementModel->_inRepeatGroup = $groupModel->canRepeat();
					$elementModel->_inJoin 				= $groupModel->isJoin() ||  $elementModel->isJoin();
					$elementModel->_editable 	= false;

					if ($elementModel->_inJoin) {
						if ($elementModel->_inRepeatGroup) {

							if (!array_key_exists($k . "_raw", $this->emailData)) {
								$this->emailData[$k."_raw"] = array();
							}
							$this->emailData[$k."_raw"][] = JArrayHelper::getValue($model->_formDataWithTableName['join'][$group->join_id][$k], $c);
						} else {
							$join = $elementModel->getJoinModel()->getJoin();
							$this->emailData[$k."_raw"] = $model->_formDataWithTableName['join'][$join->id][$k];
						}
					} else {
						//@TODO do we need to check if none -joined repeat groups have their data set out correctly?
						if (array_key_exists($key, $model->_formDataWithTableName)) {
							$rawval = JArrayHelper::getValue($model->_formDataWithTableName, $k."_raw", '');
							if ($rawval == '') {
								$this->emailData[$k."_raw"] = $model->_formDataWithTableName[$key];
							}else{
								// things like the user element only have their raw value filled in at this point
								// so don't overwrite that with the blank none-raw value
								// the none-raw value is add in getEmailValue()
								$this->emailData[$k."_raw"] = $rawval;
							}
						}
					}
					// $$$ hugh - need to poke data into $elementModel->_form->_data as it is needed
					// by CDD getOptions when building the query, to constrain the WHERE clause with
					// selected FK value.

					// $$$ rob in repeat join groups this isnt really efficient as you end up reformatting the data $c times
					$elementModel->_form->_data =& $model->_formDataWithTableName;
					$this->emailData[$k] = $elementModel->getEmailValue($this->emailData[$k."_raw"], $model->_formDataWithTableName, $c);
					if ($elementModel->_inRepeatGroup && $elementModel->_inJoin) {
						$this->emailData['join'][$groupModel->getGroup()->join_id][$k.'_raw'] = $this->emailData[$k.'_raw'];
						$this->emailData['join'][$groupModel->getGroup()->join_id][$k] = $this->emailData[$k];
					}
					if ($elementModel->isJoin()) {
						$parent_name = $elementModel->getFullName(false, true, false, true);
						if ($parent_name <> $k) {
							$this->emailData[$parent_name] = $this->emailData[$k];
							$this->emailData[$parent_name . '_raw'] = $this->emailData[$k] . '_raw';
						}
					}
				}
			}
		}
		$pk = FabrikString::safeColNameToArrayKey($tableModel->getTable()->db_primary_key);
		$this->emailData[$pk] = $tableModel->_lastInsertId;
		$this->emailData[$pk."_raw"] = $tableModel->_lastInsertId;
		return $this->emailData;
	}

	/**
	 * get a list of admins which should receive emails
	 * @return array admin user objects
	 */

	protected function getAdminInfo()
	{
		$db =& JFactory::getDBO();
		$query = 'SELECT id, name, email, sendEmail' .
					' FROM #__users' .
					' WHERE LOWER(usertype) = "super administrator" AND sendEmail = "1"';
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		return $rows;
	}

}
?>