<?php 
/**
* GuardXT for Joomla!
* @Copyright ((c) 2009 JoomlaXT
* @ All rights reserved
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @ http://www.joomlaxt.com
* @version 1.00.04
**/
defined('_JEXEC') or die('Direct Access to this location is not allowed.');
?>

<?php
jimport( 'joomla.application.component.model' );

class guardxtModelFiles extends JModel
{
var $hashes = null;
var $hashfilename = null;

	function __construct()
	{	

		parent::__construct();
		global $mainframe, $option;
	
		// Get pagination request variables
		$limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart = $mainframe->getUserStateFromRequest($option.'.limitstart', 'limitstart', 0, 'int');
	
		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
	
		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);

	}//function
	function confirm() {
		$ids = JRequest::getVar('cid',  0, '', 'array');
		foreach($ids as $id) {
			$file = $this->getTable();
			$file->load($id);
			if ($file->mtime != "") $file->time = $file->mtime;
			$file->state = "C";
			if ($file->mhash != "")	$file->hash = $file->mhash;
//			if ($file->healthcheck=="U") $file->healthcheck = "S";
			$file->store();
		}
		
	}
	function remove() {
		$ids = JRequest::getVar('cid',  0, '', 'array');
		$success = true;
		foreach($ids as $id) {
			$file = $this->getTable();
			$file->load($id);
		 	$cs = false;
			if (is_dir(JPATH_SITE.$file->path)) 
				if (rmdir (JPATH_SITE.$file->path)) $cs = true;
				else $success = false;
			else 
				if (unlink(JPATH_SITE.$file->path)) $cs = true;			
				else $success = false;
			if ($cs) {
				$file = $this->getTable();
				$file->load($id);
				$file->time = $file->mtime;
				$file->hash = $file->mhash;
				$file->state = "C";
				$file->store();
			}

		}
		return $success;	
	}
	
	function deleteTmpDir() {
	 	$config =& JFactory::getConfig();
		$path = $config->getValue('config.tmp_path');
		$files = JFolder::files($path, "", 99, true);
		$folders = JFolder::folders($path, "", 99, true);
		foreach($files as $file) {
			unlink($file);		
		}
		foreach($folders as $folder) {
			rmdir ($folder);
		}
	}
	
	function createHtaccess() {
	    $htaccess = file_get_contents(JPATH_COMPONENT_ADMINISTRATOR.DS."/assets/textfiles/htaccess.txt");
	    $x = file_put_contents(JPATH_SITE.DS.".htaccess", $htaccess);
	    chmod(JPATH_SITE.DS.".htaccess",0600);
	}
	
	function was_modified($item) {
		// extend path
		$fullpath = JPATH::clean(JPATH_SITE.$item->path, "/");
		//get som fileinfo
		$mtime = filemtime($fullpath);
		$perms = substr(decoct(fileperms($fullpath)),3);
		$hash = xtHash($fullpath);
		$hashfilename = $this->getHashFileName();
		if (  ($mtime != $item->time AND $item->state == "C")       // confirmed file - date changed
			   OR ($mtime != $item->mtime AND $item->state == "M")  // modified file - date changed again
			   OR ($hash != $item->hash AND $item->state == "C")    // confirmed file - hash changed
			   OR ($hash != $item->mhash AND $item->state == "M")	// modified file - hash changed again
			   OR ($item->hcfile == "" AND $item->state == "M")		// healthcheck not yet performed 
			   OR ($item->hcfile != "" AND $item->hcfile != $hashfilename) // healthcheck performed with out-of-date-file
			) return true;

		else return false; 
	}

	function has_hash($item) {
		if (!$this->hashes) $this->hashes = $this->getHashFiles();
		if ($h = array_search($item,$this->hashes) ) 
			return $h;
		else
			return false;
	}
	
	function initializeDB()
	{
//		$hashes = $this->getHashFiles();
//		print_r($hashes);die;
		check("init"); return;
/*		$db = JFactory::getDBO();
		$query= "TRUNCATE TABLE #__guardxt_files";  
		$db->setQuery($query);
		$db->query();
		$query= "TRUNCATE TABLE #__guardxt_runs";  
		$db->setQuery($query);
		$db->query();
		//get all files
		$files = xtUtils::getFiles(JPATH_SITE);
		$jpath = JPath::clean(JPATH_SITE, "/");
		$log = "";
		$hashes = $this->getHashFiles();
		$hashfilename = $this->getHashFileName();
		foreach ($files as $fullpath) {
		 	if (!ini_get('safe_mode')) set_time_limit(60);
			$perms = substr(decoct(fileperms($fullpath)),3);
		 	$shortpath = str_replace($jpath, "", $fullpath);
			$log.= "$shortpath added: " . date ("m d Y H:i:s.", filemtime($fullpath))."<br/>";
			$row =& $this->getTable();
			$row->type = "F";
			$row->path = $shortpath;
			$hash = xtHash($fullpath);			
			if ($h = trim($this->has_hash($shortpath) )) {
			 	if ($h != $hash) {
					$row->state = "M"; 
					$row->healthcheck = "U";
					$row->hcfile = $hashfilename;
				}
				else {
					$row->state = "C";
					$healthcheck = "S";
					$row->hcfile = $hashfilename;
				}
			}
			else {
				$row->state = "C";
				$row->healthcheck = "";
			}
			
			$row->hash = $hash;
			$row->time = filemtime($fullpath);
			$row->fp = $perms;
			$row->fpstate = "N";
			$row->store();
		}
		$folders = JFolder::folders(JPATH_SITE, "", true, true);
		foreach ($folders as $f) {
			$perms = substr(decoct(fileperms($f)),2);
		 	$f = JPath::clean(str_replace(JPATH_SITE, "", $f),"/");
			$log.= "Folder $f added: " . date ("m d Y H:i:s.", filemtime(JPATH_SITE.$f))."<br/>";
			$row =& $this->getTable();
			$row->type = "D";
			$row->path = $f;
			$row->state = "C";
			$row->time = filemtime(JPATH_SITE.$f);
			$row->fp = $perms;
			$row->fpstate = "N";
			$row->store();
		}
		
		$row = $this->getTable('runs');
		$row->type = "I";
		$row->log = $log;
		$row->time = time();	
		$row->store();
*/	 
	 
	}//function
	
	
	function _buildQuery()
	{	
	 	global $mainframe;
	 	$db = JFactory::getDBO();
	 	$filter = JRequest::getVar("filter","none");
		$search	= $mainframe->getUserStateFromRequest('search','search','',	'string');
		$search	= JString::strtolower($search);
	 	
	 	if ($filter=="healthcheck") {
			$query = "SELECT * FROM #__guardxt_files WHERE healthcheck = 'U' AND state='M' AND type='F' ORDER BY path";	
		}
	 	else {
	 	 	$where = "";
			if (trim($search) !="") {
				$where = ' AND LOWER( path ) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
			}

			$query = "SELECT * FROM #__guardxt_files WHERE (state = 'A' OR state = 'M') AND type='F' ".$where." ORDER BY path";	
		}
		return $query;
	}

	/**
	 * Retrieves the hello data
	 * @return array Array of objects containing the data from the database
	 */
	function getList()
	{
		// Lets load the data if it doesn't already exist
		if (empty( $this->_data ))
		{
			$query = $this->_buildQuery();
			$this->_list = $this->_getList( $query, $this->getState('limitstart'), $this->getState('limit') );
		}
		return $this->_list;
	}//function
	
	function getTotal()
	{
		// Load the content if it doesn't already exist
		if (empty($this->_total))
		{
			$query = $this->_buildQuery();
			$this->_total = $this->_getListCount($query);	
		}
		return $this->_total;
	}//function
  
	function getPagination()
  {
 	// Load the content if it doesn't already exist
 	if (empty($this->_pagination))
 	{
 	    jimport('joomla.html.pagination');
 	    $this->_pagination = new JPagination($this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
 	}
 	return $this->_pagination;
  }//function
  
  
  function configFile() {
   	if (is_writeable(JPATH_SITE.DS."configuration.php")) {
		chmod(JPATH_SITE.DS."configuration.php", 0444);
		$msg = JText::_("UNWRITEABLE");
		}
	else {
		chmod(JPATH_SITE.DS."configuration.php", 0644);
		$msg = JText::_("WRITEABLE");
		}
	return $msg;
	}
	
	
	function checkJoomlaHash() {
		JLoader::import('administrator.components.com_guardxt.tables.hash', JPATH_SITE);
	 	$version = new JVersion();
	 	$item = "joomla_".$version->getShortVersion();
		$filename = $item.'.txt';
		$ret = $this->checkHash($filename);
		$db = JFactory::getDBO();
		$query = "SELECT * FROM #__guardxt_hash WHERE item='$item'";		
		$db->setQuery( $query );
		$row = $db->loadObject();
		
		$hash = new TableHash($db);
		
		if (isset($row->id)) $hash->id = $row->id;
		
		$hash->item = $item;		
		if (count($ret==0)) {
			$hash->result = "S";
		}
		else
			$hash->result = "E";			
		$hash->store();
		return $ret;
	}
	
	function encrypt() {
		
		$auth->pass = JRequest::getVar('authPass');
		if ($auth->path = JRequest::getVar('authPath'));
		else $auth->path = realpath($_SERVER['DOCUMENT_ROOT'].DS."..".DS).DS;
		$auth->user = JRequest::getVar('authUser');
		
		if ($auth->pass == "" or $auth->path == "" or $auth->user == "")
			return $auth;
		
		$filepath=JPath::clean($auth->path.DS.".htpasswd", "/");
		
		$auth->htaccess = "AuthUserFile ".$filepath." \n".
						  "AuthName \"admin\"\n".
						  "AuthType Basic \n".
						  "require valid-user";
		$encryptedPassword = crypt($auth->pass);						  
		$auth->htpasswd = $auth->user.":".$encryptedPassword;
		return $auth;
	}
	
	function getHashFileName() {
	 	if (!$this->hashfilename) {
			$version = new JVersion();
	 		$item = "joomla_".$version->getShortVersion();
	 		$this->hashfilename = $item;
	 	}
	 	return $this->hashfilename;
	 	
	 	

	}
	
	function getHashFiles() {
		jimport('joomla.filesystem.file');
		$basePath = JPATH_ROOT;

		$filename = $this->getHashFileName().'.txt';
		$hashFile = JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'hashes'.DS.$filename;	
		if (!file_exists($hashFile)) return false;	
		$hashFileContents = explode("\n", JFile::read($hashFile));
		foreach( $hashFileContents as $line )
			{
			if( ! $line ) continue;
			if( strpos($line, '#') !== false ) continue;
 			list($fName, $hash) = explode('|', $line);
			$tests[$hash] = $fName;
		}//foreach
		return ($tests);
	}
	
	function checkHash($file) {
		jimport('joomla.filesystem.file');
		$basePath = JPATH_ROOT;
		$errorsFound = false;

		//--Our text file with precalculated hashes
		$hashFile = JPATH_COMPONENT_ADMINISTRATOR.DS.'assets'.DS.'hashes'.DS.$file;		
		if( ! JFile::exists($hashFile))
		{
			$msg = JText::_("HASH FILE NOT FOUND:")." ".$hashFile;
			$ret[] = $msg;
			return $ret;
		}

		//--Read the hash file
		$hashFileContents = explode("\n", JFile::read($hashFile));
		//--Build the array of filenames/hashes from hash file
		$tests = array();
		foreach( $hashFileContents as $line )
			{
			if( ! $line ) continue;
			if( strpos($line, '#') !== false ) continue;
 			list($fName, $hash) = explode('|', $line);
			$tests[$fName] = $hash;
		}//foreach

		foreach( $tests as $testPath => $testHash )
			{
	//--Use JPath::clean() to support windows (changing slashes into backslashes)
			$testFullPath = JPath::clean(JPATH_ROOT.$testPath);
			$subPath = substr($testFullPath, strlen(JPATH_ROOT) );
			
			if( JFile::exists($testFullPath) )
				{
					//--Calculate hash
					$hash = xtHash($testFullPath);
					//--Verify
					if( $hash != $testHash )
					{
						//--Hash verification failed
						$ret[] = $subPath." ".JText::_("WAS MODIFIED");
					}
				}
			}//foreach
	return $ret;

	}
}// class