/**
 * rokUtils - A set of tools for Solar Sentinel
 * 
 * @version		1.1
 * 
 * @license		MIT-style license
 * @author		Djamil Legato <djamil [at] djamil.it>
 * @client		Andy Miller @ Rockettheme
 * @copyright	Author
 */

window.addEvent('domready', function() {
	var scrollToTop = document.id('top-scroll');

	if (scrollToTop) {
		var scroll = new Fx.Scroll(window);
		scrollToTop.setStyle('outline', 'none').addEvent('click', function(e) {
			e.stop();
			scroll.toTop();
		});
	};

	// Separators hack for IE6
	if (Browser.Engine.trident4) {
		var separators = document.id('horiz-menu').getElements('.separator');
		if (separators.length) {
			separators.each(function(separator, i) {
				if (separator.hasClass('daddy')) separator.addClass('separator-daddy');
			});
		}
	}
	
	var buttons = document.id('buttons');
	
	if (buttons) {
		var lnks = buttons.getElements('a');
		lnks.each(function(lnk, i) {
			lnk.addEvent('click', function(e) {
				e.stop();
				var cookie = Cookie.read('solarsentinel-fontstyle');
				var cls = this.get('href');
				cls = cls.split("fontstyle=");
				if (cls[1]) {
					cls = cls[1];
					if ((cookie == 'f-small' && cls == 'f-larger') || (cookie == 'f-large' && cls == 'f-smaller')) cls = 'f-default';
					else if (cls == 'f-larger') cls = 'f-large';
					else if (cls == 'f-smaller') cls = 'f-small';
					Cookie.write('solarsentinel-fontstyle', cls);
					document.id(document.body).removeClass('f-default').removeClass('f-large').removeClass('f-small').addClass(cls);
				}
			});
		});
	}
});