<?php
defined('_JEXEC') or die(";)");

class oseHTML
{
	function __construct()
	{

	}

	public function getInstance($type)
	{
		static $instance;

		$classname = 'oseHtml'.ucfirst($type);

		if(is_a($instance,$classname))
		{
			if(strtolower(get_class($instance)) == strtolower($classname))
			{
				return $instance;
			}
		}

		switch($type)
		{
			case('form'):
				require_once(dirname(__FILE__).DS.'html'.DS.'form.php');
				return new $classname;
			break;

			default:
				require_once(dirname(__FILE__).DS.'html'.DS.strtolower($type).".php");
				return new $classname;
			break;
		}
	}

	public function initScript($type = 'extjs')
	{
		jimport( 'joomla.version' );
		$version = new JVersion();
		$version = substr($version->getShortVersion(),0,3);

		self::initCss();
		switch($type)
		{
			case('jquery'):
				self::script('components/com_ose_cpu/jquery/jquery.min.js',$version);
				self::script('components/com_ose_cpu/extjs/adapter/jquery/ext-jquery-adapter.js',$version);
				self::script('components/com_ose_cpu/extjs/ext-all.js',$version);

			break;

			case('extjs'):
			default:
				self::script('components/com_ose_cpu/extjs/adapter/ext/ext-base.js',$version);
				self::script('components/com_ose_cpu/extjs/ext-all.js',$version);
			break;
		}


	}

	public function initCss()
	{
		jimport( 'joomla.version' );
		$version = new JVersion();
		$version = substr($version->getShortVersion(),0,3);

		self::stylesheet('components/com_ose_cpu/extjs/resources/css/ext-all.css',$version);
		//self::stylesheet('components/com_ose_cpu/extjs/resources/css/osetheme-gray.css',$version);
		//self::stylesheet('components/com_ose_cpu/extjs/resources/css/osetheme-gray-extend.css',$version);
	}

	public static function script($file,$jVersion = '1.6',$framework = false, $relative = false, $path_only = false)
	{
		$version = new JVersion();
		$version = substr($version->getShortVersion(),0,3);
		$jVersion = $version;

		if($jVersion >= '1.6')
		{
			JHTML::script($file,$framework, $relative, $path_only);
		}
		else
		{
			$fPath = dirname($file).'/';
			$fName = basename($file);
			JHTML::script($fName,$fPath);
		}


	}

	public static function stylesheet($file, $jVersion = '1.6',$attribs = array(), $relative = false, $path_only = false)
	{

		$jVersion = self::getJoomlaVersion();
		if($jVersion >= '1.6')
		{
			JHTML::stylesheet($file, $attribs = array(), $relative = false, $path_only = false);
		}
		else
		{
			$fPath = dirname($file).'/';
			$fName = basename($file);

			JHTML::stylesheet($fName,$fPath);
		}

	}

	public static function getDateTime()
	{
		$date = JFactory::getDate();
		$jVersion = self::getJoomlaVersion();

		if($jVersion >= '1.6')
		{
			$date = JFactory::getDate(JHTML::Date($date, "Y-m-d H:i:s", false));
			return $date->toMySQL();
		}
		else
		{
			$date = JFactory::getDate(JHTML::Date($date->_date, "%Y-%m-%d %H:%M:%S"));
			return $date->toMySQL();
		}

	}

	public static function route($link)
	{
		return JRoute::_($link);
	}

	public static function date($date)
	{
		return JHTML::date($date);
	}

	public static function getJoomlaVersion()
	{
		static $jVersion;

		if(!empty($jVersion))
		{
			return $jVersion;
		}
		else
		{
			$version = new JVersion();
			$version = substr($version->getShortVersion(),0,3);
			$jVersion = $version;

			return $jVersion;
		}
	}
	public function loadViewJs($type=null)
	{
		oseHTML :: initScript($type);
		oseHTML :: initCss();
		$com= OSECPU_PATH_JS.'/com_ose_cpu/extjs';
		$jVersion = self::getJoomlaVersion();
		if (($jVersion >= '1.6' )==true)
		{
			oseHTML :: script($com.'/ose/app.msg.js', '1.6');
			$lang = JRequest::getCmd('ose_lang','en');
			if(JFile::exists(OSECPU_F_PATH.DS.'locale'.DS."ext-lang-{$lang}.js"))
			{
				oseHTML :: script($com."/locale/ext-lang-{$lang}.js", '1.6');
			}

			oseHTML :: script($com.'/ose/func.js', '1.6');

			//oseHTML :: script(OSEMSC_F_URL.'/libraries/init.js', '1.6');
		}
		else
		{
			oseHTML :: script($com.'/ose/app.msg.js');
			$lang = JRequest::getCmd('lang','en');
			oseHTML :: script($com.'/ose/joomla.core.js', '1.5');
			$strings = oseJson::encode(oseText::jsStrings());
			$document = JFactory::getDocument();
			$document->addScriptDeclaration('(function(){var strings='.$strings.';Joomla.JText.load(strings)})()');
			//oseHTML :: script(OSEMSC_F_URL.'/libraries/init.js', '1.5');
			oseHTML :: script($com.'/ose/func.js', '1.5');
		}

	}

	public function loadGridJs()
	{
		$com= OSECPU_PATH_JS.'/com_ose_cpu/extjs';
		oseHTML :: script($com.'/grid/limit.js');
		oseHTML :: script($com.'/grid/quickgrid.js');
		oseHTML :: script($com.'/grid/SearchField.js');
	}

	public function loadTinyMCE()
	{
		$com= OSECPU_PATH_JS.'/com_ose_cpu/extjs';
		oseHTML :: script($com."/htmleditor/tiny_mce/tiny_mce.js", '1.6');
		oseHTML :: script($com."/htmleditor/TinyMCE.js", '1.6');
	}

	public function loadMultiSelect()
	{
		$com= OSECPU_PATH_JS.'/com_ose_cpu/extjs';

		oseHTML :: script($com.'/multiselect/MultiSelect.js');
		oseHTML :: stylesheet($com.'/multiselect/MultiSelect.css');
		oseHTML :: script($com.'/multiselect/ItemSelector.js');
	}

	public function loadPMJs()
	{
		oseHtml::script('administrator/components/com_ose_commerce/helpers/js/pm.js','1.6');
		oseHtml::script('administrator/components/com_ose_commerce/helpers/js/form.js','1.6');
	}

	public function loadOrderJs()
	{
		oseHtml::script('administrator/components/com_ose_commerce/helpers/js/orders.js','1.6');
	}

	public function loadURIJs()
	{
		$document = JFactory::getDocument();
		$uri = JURI::root();
		$document->addScriptDeclaration('var getCurrentLocation = function() {return "'.$uri.'"};//Ext.urlEncode("'.$uri.'");}');
	}

	function matchScript($file,$app)
	{
		switch($app)
		{
			case('msc'):
				$com = 'com_ose'.$app;
			break;
			default:
				$com = 'com_ose_'.$app;
			break;
		}
		$rFile = str_replace('components/'.$com.'/','',$file);
		$rFile = str_replace(array('/','\\'),DS,$rFile);
		//oseExit(JPATH_SITE.DS.'ose'.DS.$app.DS.$rFile);
		if(JFile::exists(JPATH_SITE.DS.'ose'.DS.$app.DS.$rFile))
		{
			oseHTML :: script("ose/{$app}/{$rFile}");
		}
		else
		{
			if(JFile::exists(JPATH_SITE.DS.$file))
			{
				oseHTML :: script($file);
			}
		}
	}

}

class oseHTMLDraw extends oseInit
{
	protected $html = null;
	protected $level = 0;

	function __construct()
	{
		$this->registerTask('output','toString');
	}

	function toString()
	{
		return $this->html;
	}

	function output()
	{
		$html = $this->html;
		$this->html = null;
		return $html;
	}

	function append($html)
	{
		$this->html .= $html;
	}

	function addBreak()
	{
		$this->append("\r\n");
	}

	function addLevel()
	{
		$this->level += 1;
	}

	function subLevel()
	{
		$this->level -= 1;

		if($this->level < 0)
		{
			$this->level = 0;
		}
	}

	function setLevel($level)
	{
		$this->level = $level;
	}

	function addTab($num = 1)
	{
		$string = str_repeat("\t",$num);
		$this->append($string);
	}

	// shortcut
	function sc($event)
	{
		switch($event)
		{
			case('a'):
				$this->addLevel();
			break;

			case('s'):
				$this->subLevel();
			break;

			case('e'):
				$this->addBreak();
			break;

			case('t'):
				$this->addTab($this->level+1);
			break;

			case('et'):
				$this->sc('e');
				$this->sc('t');
			break;

			// et add level
			case('eta'):
				$this->addLevel();
				$this->sc('e');
				$this->sc('t');
			break;

			// et sub level
			case('ets'):
				$this->subLevel();
				$this->sc('e');
				$this->sc('t');
			break;
		}
	}
}