<?php
if (!defined('_JEXEC') && !defined('OSE_ADMINPATH'))
{
	die("Direct Access Not Allowed");
}

class oseDB
{
	function __construct()
	{

	}

	public static function instance($type = null)
	{
		static $instance;

		if(empty($instance))
		{
				$instance = JFactory::getDBO();
		}

		return $instance;
	}

	public static function update($table,$keyId,$updateValues)
	{
		$db = oseDB::instance();
		oseDB::lock($table);
		$tables = $db->getTableFields($table);
		$temp = array();
		if (!empty($tables))
		{
		//oseExit($filterValues);
			foreach ( $tables[$table] as $field => $info)
			{
				if(isset($updateValues[$field]))
				{
					$temp[$field] = $updateValues[$field];
				}
			}

			$filterValues = array();
			foreach( $temp as $key => $value)
			{
				if($key == $keyId)
				{
					continue;
				}
				$filterValues[$key] = $db->Quote($value);
			}

			$sql = array();

			foreach($filterValues as $key => $value)
			{
				$sql[] = "`{$key}` = {$value}";
			}

			if(empty($sql))
			{
				oseDB::unlock();
				return true;
			}
			$query = " UPDATE `{$table}` "
					." SET  ". implode(',',$sql)
					." WHERE `{$keyId}` = ".$db->Quote($updateValues[$keyId])
					;

			$db->setQuery($query);

			$result = oseDB::query();

			oseDB::unlock();

			return $result;
		}
		else
		{
			oseDB::unlock();
			return true;
		}
	}

	public static function insert($table,$insertValues)
	{
		$db = oseDB::instance();
		oseDB::lock($table);
		//oseExit($table);
		$tables = $db->getTableFields($table);

		$temp = array();
		if (!empty($tables))
		{
			foreach ( $tables[$table] as $field => $info)
			{
				if(isset($insertValues[$field]))
				{
					$temp[$field] = $insertValues[$field];
				}
			}

			$filterValues = array();
			foreach( $temp as $key => $value)
			{
				$filterValues[$key] = $db->Quote($value);
			}
			//oseExit($filterValues);

			$sql = array();

			$sql1 = '`'.implode('`,`',array_keys($filterValues)).'`';
			$sql2 = ''.implode(',',$filterValues).'';

			if(empty($filterValues))
			{
				oseDB::unlock();
				return true;
			}
			$query = " INSERT INTO `{$table}` "
					." ({$sql1})  "
					." VALUES"
					." ({$sql2})"
					;

			$db->setQuery($query);

			$result = (oseDB::query())?$db->insertid():false;

			oseDB::unlock();

			return $result;
		}
		else
		{
			oseDB::unlock();
			return true;
		}
	}

	public static function delete($table,$uniqueKeys)
	{
		$db = oseDB::instance();
		foreach($uniqueKeys as $k => $v)
		{
			$where[] = "`{$k}`=".$db->Quote($v);
		}
		$where= self :: implodeWhere($where);
		$query = " DELETE FROM `{$table}`"
				. $where
				;
		$db->setQuery($query);
		return $db->query();
	}

	public static function loadList($type = 'array',$key = null)
	{
		$db = oseDB::instance();

		switch($type)
		{
			case('obj'):
				return $db->loadObjectList($key);
			break;

			default:
				return $db->loadAssocList($key);
			break;
		}
	}

	public static function loadItem($type = 'array',$key = null)
	{
		$db = oseDB::instance();

		switch($type)
		{
			case('obj'):
				return $db->loadObject();
			break;

			default:
				return $db->loadAssoc();
			break;
		}
	}

	public function query($unlock = false)
	{
		$testMode = 1;

		$db = oseDB::instance();

		if(!$db->query())
		{
			if($testMode == 1)
			{
				oseExit($db->getErrorMsg());
			}

			if($unlock)
			{
				oseDB::unlock();
			}

			return false;
		}

		return true;
	}

	public static function lock($query)
	{
		$db = oseDB::instance();
		$db->setQuery("LOCK TABLE ". $query);
		return $db->query();
	}

	public static function unlock()
	{
		$db = oseDB::instance();
		$query = "UNLOCK TABLES";
		$db->setQuery($query);
		return $db->query();
	}

	public static function implodeWhere($where = array())
	{
		$where = ( count( $where ) ? ' WHERE (' . implode( ') AND (', $where ) . ')' : '' );
		return $where;
	}

}