<?php
defined('_JEXEC') or die(";)");

class oseObject
{
	function __construct()
	{
		
	}
	
	function get($key,$default = null)
	{
		if(!isset($this->{$key}))
		{
			$this->{$key} = $default;
		}
		return $this->{$key};
	}
	
	function set($key,$value = null)
	{
		$this->{$key} = $value;
		
		return true;
	}
	
	public static function getValue($item,$key,$default = null)
	{
		$isObj = self::isObject($item);
		
		if($isObj)
		{
			return empty($item->{$key})?$default:$item->{$key};
		}
		else
		{
			return empty($item[$key])?$default:$item[$key];
		}
	}
	
	public static function setValue(&$item,$key,$value)
	{
		$isObj = self::isObject($item);
		
		if($isObj)
		{
			$item->{$key} = $value;
		}
		else
		{
			$item[$key] = $value;
		}
		
		return $item;
	}
	
	static function getParams($item,$type = 'obj')
	{
		$mode = ($type == 'obj')?false:true;
		$params = self::getValue($item,'params','{}');
		$params = oseJson::decode($params,$mode);
		
		return $params;
	}
	
	static function setParams($item,$params)
	{
		$itemParams = self::getValue($item,'params','{}');
		$itemParams = oseJson::decode($itemParams);
		
		if(!is_Array($params))
		{
			$params = (array)$params;
		}
		
		foreach($params as $key => $value)
		{
			$itemParams = oseObject::setValue($itemParams,$key,$value);
		}
		
		$itemParams = oseJson::encode($itemParams);
		
		$item = oseObject::setValue($item,'params',$itemParams);

		return $item;
	}
	
	private static function isObject($item)
	{
		if(is_object($item))
		{
			return true;
		}
		else
		{
			return false; // array
		}
	}
	
	// value for example, 2 setting, int.1, int and 1
	function checkVarType($require, $args ,$auto_correct = true)
	{
		foreach ($require as $key => $value)
		{
			$value = explode('.',$value);
			$value[1] = empty($value[1])?0:$value[1];
			
			$type = $value[0];
			$num = $value[1];
			$isType = call_user_method('is'.$type,$this,$args[$key],$num,false);
			
			if(!$isType)
			{
				return false;
			}
		}
		
		return true;
	}
	
	protected function isInt($value,$num,$auto_correct)
	{
		if(is_Numeric($value))
		{
			$value = $value;
		}
		else
		{
			$value = false;
		}
		
		return $value;
	}
	
	protected function isString($value,$num,$auto_correct)
	{
		if(is_string($value))
		{
			if(strlen($value) > $num)
			{
				if($auto_correct)
				{
					$value = substr($value,0,$num);
				}
			}
		}
		else
		{
			$value = false;
		}
		
		return $value;
	}
	
	protected function isFloat($value,$num,$auto_correct)
	{
		
		if(is_float($value))
		{
			if(!empty($num))
			{
				if(strpos($value,'.'))
				{
					$number = explode('.',$value);
					if(strlen($number[1]) > $num)
					{
						if($auto_correct)
						{
							$value = round($value,$num);
						}
					}
				}
			}
			
		}
		else
		{
			$value = false;
		}
		
		return $value;
	}
	
	protected function isArray($value,$num,$auto_correct)
	{
		$value = (!is_array($value))?false:$value;
		
		return $value;
	}
	
	
}

/*
 *  for 1.5 to do js as 1.6
 */
class oseText
{
	 /*
	 * javascript strings
	 */
	static $strings=array();

	/**
	 * Translates a string into the current language.
	 *
	 * @param	string			The string to translate.
	 * @param	boolean|array	boolean: Make the result javascript safe. array an array of option as described in the JText::sprintf function
	 * @param	boolean			To interprete backslashes (\\=\, \n=carriage return, \t=tabulation)
	 * @param	boolean			To indicate that the string will be push in the javascript language store
	 * @return	string			The translated string or the key is $script is true
	 * @example	<script>alert(Joomla.JText._('<?php echo JText::_("JDEFAULT", array("script"=>true));?>'));</script> will generate an alert message containing 'Default'
	 * @example	<?php echo JText::_("JDEFAULT");?> it will generate a 'Default' string
	 * @since	1.5
	 *
	 */
	public static function _($string, $jsSafe = false, $interpreteBackSlashes = true, $script = false)
	{
		$lang = JFactory::getLanguage();
		if (is_array($jsSafe)) {
			if (array_key_exists('interpreteBackSlashes', $jsSafe)) {
				$interpreteBackSlashes = (boolean) $jsSafe['interpreteBackSlashes'];
			}
			if (array_key_exists('script', $jsSafe)) {
				$script = (boolean) $jsSafe['script'];
			}
			if (array_key_exists('jsSafe', $jsSafe)) {
				$jsSafe = (boolean) $jsSafe['jsSafe'];
			}
			else {
				$jsSafe = false;
			}
		}
		if ($script) {
			self::$strings[$string] = $lang->_($string, $jsSafe);
			return $string;
		}
		else {
			return $lang->_($string, $jsSafe);
		}
	}
	
	public static function jsStrings()
	{
		return self::$strings;
	}
}
?>