<?php
abstract class oseInit
{
	protected $task = array();
	protected $instance = array();
	
	protected function registerTask($task,$funcName)
	{
		$this->task[$task] = $funcName;
	}

	protected function registerInstance($task,$instanceName)
	{
		$this->instance[$task] = $instanceName;
	}

	function __call($name,$args)
	{
		if(isset($this->task[$name]))
		{
			return call_user_func_array(array($this,$this->task[$name]),$args);
		}
		else
		{
			oseExit($name. 'Error');
		}
	}
	
	function get($key,$default = null)
	{
		if(isset($this->{$key}))
		{
			return $this->{$key};
		}
		return $default;
	}
	
	function set($key,$value = null)
	{
		$oldkey = $this->get($key);
		$this->{$key} = $value;
		
		return $oldkey;
	}
	
	function __toString()
	{
		return get_class($this);
	}
	
	protected function toArray()
	{
		$vars = get_class_vars( get_class($this) );
		unset($vars['task']);
		unset($vars['instance']);
		unset($vars['prefix']);
		unset($vars['table']);
		unset($vars['isNew']);
		
		foreach($vars as $key => $value)
		{
			$vars[$key] = $this->get($key);
		}
		
		return $vars;
	}
	
	function create()
	{
		$vals = $this->toArray();
		unset($vals['id']);
		$vals['params'] = oseJson::encode($vals['params']);
		return oseDB::insert($this->table,$vals);
	}
	
	function update()
	{
		$vals = $this->toArray();
		$vals['params'] = oseJson::encode($vals['params']);
		return oseDB::update($this->table,'id',$vals);
	}
	
	function delete()
	{
		$where = array();
		$where['id'] = $this->get('id');
		return oseDB::delete($this->table,$where);
	}
	
	function __construct($info = array())
	{
		if(!empty($info))
		{
			foreach($info as  $key => $value)
			{
				if( in_array($key,array('params','data','transactions')))
				{
					if(!is_array($value) && !is_object($value) && is_string($value))
					{
						if($key == 'data')
						{
							$this->set($key,oseJson::decode($value,true));
						}
						else
						{
							$this->set($key,oseJson::decode($value));
						}
					}
					else
					{
						if(empty($value))
						{
							$this->set($key,$this->get($key));
						}
						else
						{
							$this->set($key,$value);
						}
						
					}
						
					//$this->set($key,$value);
					
				}
				else
				{
					$this->set($key,$value);
				}
			}
		}
			
	}
}
?>
