<?php
/**
  * @version     3.0 +
  * @package       Open Source Excellence Security Suite
  * @subpackage    Open Source Excellence CPU
  * @author        Open Source Excellence {@link http://www.opensource-excellence.com}
  * @author        Created on 30-Sep-2010
  * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
  *
  *
  *  This program is free software: you can redistribute it and/or modify
  *  it under the terms of the GNU General Public License as published by
  *  the Free Software Foundation, either version 3 of the License, or
  *  (at your option) any later version.
  *
  *  This program is distributed in the hope that it will be useful,
  *  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *  GNU General Public License for more details.
  *
  *  You should have received a copy of the GNU General Public License
  *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  *  @Copyright Copyright (C) 2008 - 2010- ... Open Source Excellence
*/
if (!defined('_JEXEC') && !defined('OSE_ADMINPATH'))
{
	die("Direct Access Not Allowed");
}

class oseAntihacker {
	private $ip= null;
	private $url= null;
	private $referer= null;
	private $tags= null;
	private $target= null;
	private $scankey= true;
	private $scancookies= true;
	private $allowExts= null;
	private $threshold= 0;
	private $logtime= null;
	private $db= null;
	private $json= null;
	private $storage= null;
	public $centrifuge= array();
	private $layer1Detected= array();
	private $layer2Detected= array();
	private $l2rulesConf = array();
	private $blockIP= true;
	function __construct() {
		self :: getBasicInfo();
	}
	private function getBasicInfo() {
		$this->url= 'http://'.str_replace("?".$_SERVER['QUERY_STRING'], "", $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']);
		if(isset($_SERVER['HTTP_REFERER'])) {
			$this->referer= $_SERVER['HTTP_REFERER'];
		} else {
			$this->referer= "N/A";
		}
		$this->ip= self :: getRealIP();
		$this->scankey= true;
		$this->blockIP= true;
		$this->scancookies= true;
		$this->allowExts= null;
		$this->threshold= 35;
		$this->layer1Detected= array();
		$this->layer2Detected= array();
		// Get Configuration;
		if (class_exists("athDB"))
		{
			$this->db= athDB :: instance();
		}
		else
		{
			$this->db= oseDB :: instance();
		}
		if (class_exists("athJSON"))
		{
			$this->json= new athJSON();
		}
		else
		{
			$this->json= new oseJSON();
		}
		$db = $this->db;
		$query= "SELECT * FROM `#__ose_secConfig` ";
		$db->setQuery($query);
		$results= $db->loadAssocList();
		if (!empty($results))
		{
		 foreach($results as $result) {
			switch($result['key']) {
				case 'scankey' :
					$this->scankey= $result['value'];
					break;
				case 'scankeyLength' :
					$this->scankeyLength= $result['value'];
					break;
				case 'scancookies' :
					$this->scancookies= $result['value'];
					break;
				case 'threshold' :
					$this->threshold= $result['value'];
					break;
				case 'allowExts' :
					$this->allowExts= $result['value'];
					break;
				case 'scanFileVirus':
					$this->scanFileVirus= $result['value'];
					break;
				case 'blockIP' :
					$this->blockIP= $result['value'];
					break;
				// Addons;
				case 'antiflooding' :
					$this->antiflooding= $result['value'];
					break;
				case 'decduration' :
					$this->decduration= $result['value'];
					break;
				case 'maxvisits' :
					$this->maxvisits= $result['value'];
					break;
				// Added in RC2 REV1
				case 'runCentrifuge' :
					$this->runCentrifuge= $result['value'];
					break;
				case 'convertFromRepetition' :
					$this->convertFromRepetition= $result['value'];
					break;
				case 'convertFromCommented' :
					$this->convertFromCommented= $result['value'];
					break;
				case 'convertFromWhiteSpace' :
					$this->convertFromWhiteSpace= $result['value'];
					break;
				case 'convertFromJSCharcode' :
					$this->convertFromJSCharcode= $result['value'];
					break;
				case 'convertJSRegexModifiers' :
					$this->convertJSRegexModifiers= $result['value'];
					break;
				case 'convertEntities' :
					$this->convertEntities= $result['value'];
					break;
				case 'convertQuotes' :
					$this->convertQuotes= $result['value'];
					break;
				case 'convertFromSQLHex' :
					$this->convertFromSQLHex= $result['value'];
					break;
				case 'convertFromSQLKeywords' :
					$this->convertFromSQLKeywords= $result['value'];
					break;
				case 'convertFromControlChars' :
					$this->convertFromControlChars= $result['value'];
					break;
				case 'convertFromNestedBase64' :
					$this->convertFromNestedBase64= $result['value'];
					break;
				case 'convertFromOutOfRangeChars' :
					$this->convertFromOutOfRangeChars= $result['value'];
					break;
				case 'convertFromXML' :
					$this->convertFromXML= $result['value'];
					break;
				case 'convertFromJSUnicode' :
					$this->convertFromJSUnicode= $result['value'];
					break;
				case 'convertFromUTF7' :
					$this->convertFromUTF7= $result['value'];
					break;
				case 'convertFromConcatenated' :
					$this->convertFromConcatenated= $result['value'];
					break;
				case 'convertFromProprietaryEncodings' :
					$this->convertFromProprietaryEncodings= $result['value'];
					break;
			}
			if (strstr($result['key'], 'l2ruleid'))
			{
				$l2ruleid = str_replace('l2ruleid_', '', $result['key']);
				$this->l2rulesConf[$l2ruleid] = $result['value'] ;
			}
		 }
		}
	}
	function hackScan() {
		$ipStatus= self :: checkIPStatus();
		if ($ipStatus=='1')
		{
			self :: showBanPage();
		}
		else
		{
			self :: detectAttack();
			if(!empty($this->layer1Detected) || !empty($this->layer2Detected)) {
				if ($ipStatus=='2' || $ipStatus=='0')
				{
					self :: controlAttack();
				}
			}
		}

	}
	private function showBanPage() {
		$systemSetting = self::getSysSetting();
		$customInfo = $systemSetting->getConfiguration();
		$adminEmail = (isset($customInfo['adminEmail']))?$customInfo['adminEmail']: "";
		$customBanPage=(!empty($customInfo['customBanpage'])) ? $customInfo['customBanpage'] : "Banned";
		$pageTitle=(!empty($customInfo['pageTitle'])) ? $customInfo['pageTitle'] : "OSE Security Suite";
		$metaKeys=(!empty($customInfo['metaKeywords'])) ? $customInfo['metaKeywords'] : "OSE Security Suite";
		$metaDescription=(!empty($customInfo['metaDescription'])) ? $customInfo['metaDescription'] : "OSE Security Suite";
		$metaGenerator=(!empty($customInfo['metaGenerator'])) ? $customInfo['metaGenerator'] : "OSE Security Suite";

		$banhtml= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
					<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
					<head>
					  <meta http-equiv="content-type" content="text/html; charset=utf-8" />
					  <meta name="robots" content="index, follow" />
					  <meta name="keywords" content="'.$metaKeys.'" />
					  <meta name="description" content="'.$metaDescription.'" />
					  <meta name="generator" content="'.$metaGenerator.'" />
					  <title>'.$pageTitle.'</title>
					</head>
					<body>
		     		<div style="margin:auto;width:780px;border:0px solid #0082b0;padding:0px 10px 10px 10px;z-index:100;color:#000000;">
					<br/>
					'.$customBanPage.'
					<div style="font-family: arial,helvetica,sans-serif;background-color:#ffffff;padding: 10px 0px 0px 0px" align="center"><font color="#666666" size="1">Your IP address is '.$this->ip.'. If you believe this is an error, please contact the <a href="mailto:'.$adminEmail.'?Subject=Inquiry:%20Banned%20for%20suspicious%20hacking%20behaviour - IP: '.$this->ip.' - Violation"> Webmaster </a>.</font></div>
					</div>
					</body>
				</html>';
		echo $banhtml;
		exit;
	}
	/* return values:
	 * 0 --> no record / normal
	 * 1 --> blacklisted
	 * 2 --> monitored
	 * 3 --> whitelisted
	*/
	private function checkIPStatus() {
		$db= $this->db;
		$query= "SELECT acl.status FROM `#__oseipm_acl` as acl, `#__oseipm_iptable` as iptable WHERE acl.id = iptable.acl_id AND iptable.ip='".$this->ip."' LIMIT 1";
		$db->setQuery($query);
		$result= $db->loadResult();
		$result= (int) $result;
		return $result;
	}
	private function getRealIP() {
		$ip= false;
		if(!empty($_SERVER['HTTP_CLIENT_IP'])) {
			$ip= $_SERVER['HTTP_CLIENT_IP'];
		}
		if(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			$ips= explode(", ", $_SERVER['HTTP_X_FORWARDED_FOR']);
			if($ip) {
				array_unshift($ips, $ip);
				$ip= false;
			}
			for($i= 0; $i < count($ips); $i++) {
				if(!preg_match("/^(10|172\.16|192\.168)\./i", $ips[$i])) {
					if(version_compare(phpversion(), "5.0.0", ">=")) {
						if(ip2long($ips[$i]) != false) {
							$ip= $ips[$i];
							break;
						}
					} else {
						if(ip2long($ips[$i]) != -1) {
							$ip= $ips[$i];
							break;
						}
					}
				}
			}
		}
		return($ip ? $ip : $_SERVER['REMOTE_ADDR']);
	}
	function getLayer1Signatures() {
		include_once(dirname(__FILE__).OSEDS."library".OSEDS."signature.php");
		return getSignatures();
	}
	private function getRules($type, $ruleaction, $targetAction= null, $array= true, $times= null) {
		$db= $this->db;
		$where= '';
		if(!empty($times)) {
			$where .= " AND `times` = ".(int) $times;
		}
		if(!empty($targetAction)) {
			$where .= " AND `targetaction` = ".(int) $targetAction;
		}
		if($type == 'l1') {
			$query= "SELECT `signature` FROM `#__oseath_l1rules` WHERE `signatureaction` = ".(int) $ruleaction.$where;
		} else {
			$query= "SELECT `key` FROM `#__oseath_l2rules` WHERE `keyaction` = ".(int) $ruleaction.$where;
		}
		$db->setQuery($query);
		if($array == true) {
			$rules= $db->loadAssocList();
		} else {
			$rules= $db->loadObjectList();
		}
		return $rules;
	}
	private function checkTarget($type, $rule, $target, $ruleAction= null, $targetAction= null, $array= true, $times= null) {
		$db= $this->db;
		$where= '';
		if(!empty($times)) {
			$where .= " AND `times` = ".(int) $times;
		}
		if(!empty($targetAction)) {
			$where .= " AND `targetaction` = ".(int) $targetAction;
		}
		if ($type == 'l1')
		{
			$query= "SELECT * FROM `#__oseath_l1rules` WHERE `signatureaction` = 3 AND `signature` = ". $db->Quote($rule, true);
			$db->setQuery($query);
		}
		else
		{
			$query= "SELECT * FROM `#__oseath_l2rules` WHERE `keyaction` = 3 AND `key` = ". $db->Quote($rule, true);
			$db->setQuery($query);
		}
		if($array == true) {
			$ruleExist= $db->loadAssocList();
		} else {
			$ruleExist= $db->loadObjectList();
		}

		if (empty($ruleExist))
		{
 		  if($type == 'l1') {
			if(!empty($ruleAction)) {
					$where .= " AND `signatureaction` = ".(int) $ruleAction;
				}
			} else {
				if(!empty($ruleAction)) {
					$where .= " AND `keyaction` = ".(int) $ruleAction;
				}
			}
			$query= "SELECT * FROM `#__oseath_{$type}rules` WHERE `target` = ".$db->Quote($target, true).$where;
			$db->setQuery($query);
			if($array == true) {
				$rules= $db->loadAssocList();
			} else {
				$rules= $db->loadObjectList();
			}
			return $rules;
		}
		else
		{
			return $ruleExist;
		}
	}
	private function insertTarget($type, $rule, $target) {
		$db= $this->db;
		if($type == 'l1') {
			$query= "INSERT INTO `#__oseath_l1rules` ".	" (`id`, `signature`, `signatureaction`, `target`, `targetaction`, `times`)"
					." VALUES (NULL, ".$db->Quote($rule, true).", 1, ".$db->Quote($target, true).", 1, 1);";
		} else {
			$filters = null;
			foreach ($this->layer2Detected as $l2detected)
			{
				$filters .=	$l2detected ['filtersID'];
			}
			$query= "INSERT INTO `#__oseath_l2rules` ".	" (`id`, `key`, `keyaction`, `target`, `targetaction`, `times`, `filters`)"
					." VALUES (NULL, ".$db->Quote($rule, true).", 1, ".$db->Quote($target, true).", 1, 1, ".$db->Quote($filters, true).");";
		}
		$db->setQuery($query);
		if($db->query()) {
			return $db->insertid();
		} else {
			return false;
		}
	}
	private function detectAttack() {
		$layer1= self :: layer1Detect();
		if(!empty($layer1)) {
			$this->layer1Detected['score']= '100';
			$this->layer1Detected['trgRule']= $layer1['signature'];
			$this->layer1Detected['target']= $layer1['target'];
		}
		$layer2= self :: layer2Detect();
		if (!empty($_FILES))
		{
			self::checkFileTypes($_FILES);
			self::scanFileVirus($_FILES);
		}
		if (isset($this->antiflooding) && $this->antiflooding==true)
		{
			self::scanFlooding($this->decduration, $this->maxvisits);
		}
	}
	private function controlAttack() {
		$totalImpact= 0;
		$targetid= array();
		$action= array();
		$attackType= array();
		$action['trim']= false;
		$action['filter']= false;
		$pass1 = false;
		$pass2 = false;

		if(!empty($this->layer1Detected)) {
			$targetStatus= self :: checkTarget('l1', $this->layer1Detected['trgRule'], $this->layer1Detected['target']);
			if(empty($targetStatus)) {
				$targetid['l1'][]= self :: insertTarget('l1', $this->layer1Detected['trgRule'], $this->layer1Detected['target']);
			} else {

				if($targetStatus[0]['signatureaction'] == 3 || $targetStatus[0]['targetaction'] == 3) {
					$targetid['l1'][]= $targetStatus[0]['id'];
					$pass1 =true;
				} else {
					$filterkey= self :: getKeyFilterStatus('l1', $this->layer1Detected['trgRule']);
					if($filterkey > 0 || $this->blockIP==2) {
						$action['trim']= true;
						$l1id = $targetid['l1'][]= self :: insertTarget('l1', $this->layer1Detected['trgRule'], $this->layer1Detected['target']);
						self :: trimAttack($this->layer1Detected['trgRule'], $this->layer1Detected['target'],$l1id);
					} else {
						$targetid['l1'][]= $targetStatus[0]['id'];
					}
				}
			}
			$attackType[]= 'L1';
			$totalImpact += $this->layer1Detected['score'];
		}
		else
		{
			$pass1 = true;
		}

		if(!empty($this->layer2Detected)) {
			foreach($this->layer2Detected as $key => $value) {
				$targetStatus= self :: checkTarget('l2', $key, $value['target']);
				if(empty($targetStatus)) {
					$targetid['l2'][]= self :: insertTarget('l2', $key, $value['target']);
				} else {
					if($targetStatus[0]['keyaction'] == 3 || $targetStatus[0]['targetaction'] == 3) {
						$targetid['l2'][]= $targetStatus[0]['id'];
						$pass2 =true;
					} else {
						$filterlevel= self :: getKeyFilterStatus('l2', $key);
						if($filterlevel > 0 || $this->blockIP==2) {
							$action['filter']= true;
							$l2id = $targetid['l2'][]= self :: insertTarget('l2', $key, $value['target'],$targetid);
							self :: filterAttack($key, $value['value'], $value['filtersID'], $filterlevel,$l2id);
						} else {
							$targetid['l2'][]= $targetStatus[0]['id'];
						}
					}
				}
				$totalImpact += $value['impact'];
			}
			$attackType[]= 'L2';
		}
		else
		{
			$pass2 = true;
		}
		if ($pass1 == true && $pass2 == true)
		{
			return;
		}
		if($totalImpact > $this->threshold) {

		if ($this->blockIP==1)
			{
				$acl_id= self :: addBlacklistedIP($attackType);
				if(!empty($acl_id)) {
					if(self :: logAttack($acl_id, $targetid, $totalImpact)) {
						$ipStatus= self :: checkIPStatus();
						if($ipStatus == '1') {
							self :: send_email($ipStatus, $attackType, $acl_id, $targetid, $totalImpact);
							self :: showBanPage();
						}
					}
				}
			}
			elseif ($this->blockIP==2)
			{
				$acl_id= self :: addBlacklistedIP($attackType,2);
				if(!empty($acl_id)) {
					if(self :: logAttack($acl_id, $targetid, $totalImpact)) {
						$ipStatus= self :: checkIPStatus();
							self :: send_email($ipStatus, $attackType, $acl_id, $targetid, $totalImpact);
					}
				}
			}
			else
			{
				$acl_id= self :: addBlacklistedIP($attackType,2);
				if(!empty($acl_id)) {
					if(self :: logAttack($acl_id, $targetid, $totalImpact)) {
						//$ipStatus= self :: checkIPStatus();
							self :: send_email(3, $attackType, $acl_id, $targetid, $totalImpact);
							self :: show403("Permission Denied");
					}
				}
			}

		} else {
			$acl_id= self :: addBlacklistedIP($attackType, 2);
			if(!empty($acl_id)) {
				if(self :: logAttack($acl_id, $targetid, $totalImpact)) {
				}
			}
			return true;
		}
	}
	private function getKeyFilterStatus($type, $rule) {
		$db= $this->db;
		if($type == 'l1') {
			$table= "#__oseath_l1rules";
			$field= "signature";
			$fieldaction= "signatureaction";
		} else {
			$table= "#__oseath_l2rules";
			$field= "key";
			$fieldaction= "keyaction";
		}
		$query= "SELECT MAX(`{$fieldaction}`) FROM `{$table}` WHERE (`{$fieldaction}`= 2 OR `{$fieldaction}`= 4) AND `{$field}` = ".$db->Quote($rule, true);
		$db->setQuery($query);
		return $db->loadResult();
	}
	/* -- Remove later --
	function filterAttack()
	{
		// Filter data if they are in the DB;
		$FilteredPatternKeys = self::getWhitelistPatternKeys (2);
		//print_R($FilteredPatternKeys); exit;
		if(!empty($FilteredPatternKeys) && !empty($this->layer2Detected))
		{
			// check if this field is part of the exceptions
			foreach ($this->layer2Detected as $key => $detected)
			{
				if (is_array($FilteredPatternKeys) && in_array($key , $FilteredPatternKeys, true))
				{
					self::htmlPurify($key, $detected['value']);
				}
			}
		}
	}
	*/
	function logAttack($acl_id, $targetid, $totalImpact) {
		$db= $this->db;
		$query= "SELECT count(*) FROM `#__oseath_alerts` WHERE `aclid` = ".(int) $acl_id;
		$db->setQuery($query);
		$this->logtime= date("Y-m-d, h:i:s");
		$result= $db->loadResult();
		$l1ruleids=(isset($targetid['l1'])) ? $this->json->encode($targetid['l1']) : '';
		$l2ruleids=(isset($targetid['l2'])) ? $this->json->encode($targetid['l2']) : '';
		if($result > 0) {
			$query= " UPDATE `#__oseath_alerts` SET `l1ruleids` = ".$db->Quote($l1ruleids, true).			", `l2ruleids` = ".$db->Quote($l2ruleids, true).			", `score` = ".$db->Quote($totalImpact).			", `datetime` = ".$db->Quote($this->logtime).			", `referer` = ".$db->Quote($this->referer, true).			" WHERE `aclid` =".(int) $acl_id;
		} else {
			$query= " INSERT INTO `#__oseath_alerts`".
					" (`id`,`aclid`,`l1ruleids`,`l2ruleids`,`datetime`,`score`,`referer`,`notified`)".
					" VALUES ".
					" (NULL , '".(int) $acl_id."', ".$db->Quote($l1ruleids, true).", ".$db->Quote($l2ruleids, true).", ".$db->Quote($this->logtime).
					", ".$db->Quote($totalImpact).", ".$db->Quote($this->referer, true)." , NULL);";
		}
		$db->setQuery($query);
		if($db->query()) {
			return true;
		} else {
			return false;
		}
	}
	/* function layer1Detect()
	 * returns true if attacks are found; false if no attacks are found
	 */
	private function getWhitelistSignatureKeys() {
		$return= array();
		$i= 0;
		$ignoreSignatures= self :: getRules('l1', 2, null, false, null);
		if(!empty($ignoreSignatures)) {
			foreach($ignoreSignatures as $ignoreSignature) {
				$return[$i]= str_replace(array("SIG[", "]"), "", $ignoreSignature->signature);
				$i++;
			}
		}
		return $return;
	}
	private function getWhitelistPatternKeys($status) {
		$return= array();
		$i= 0;
		$ignorePatterns= self :: getRules('l2', $status, null, false, null);
		if(!empty($ignorePatterns)) {
			foreach($ignorePatterns as $ignorePattern) {
				$return[$i]= $ignorePattern->name;
				$i++;
			}
		}
		return $return;
	}
	private function transformSignature($value) {
		$value= htmlspecialchars(str_replace(array(" \n", "\n", " ", "\r"), "", $value));
		$quotes= array('/"/', "/'/");
		$replacements= array('%22', '%27');
		$value= preg_replace($quotes, $replacements, $value);
		return $value;
	}
	private function layer1Detect() {
		$switch= '';
		$violation= '';
		$return= array();
		$urlQuery= htmlspecialchars(str_replace(array("%3C", "%3E", "%5C", " ", "\\\\"), array("<", ">", "\\","%20", "\\"), $_SERVER['QUERY_STRING']));
		if(empty($urlQuery)) {
			return false;
		}
		$db= $this->db;
		$whitelistSigkeys= self :: getWhitelistSignatureKeys();
		$layer1Rules= self :: getLayer1Signatures();
		// Loop through the exploit list and compare it to the query string
		foreach($layer1Rules as $key => $value) {
			$check= self :: transformSignature($value);
			if(stristr($urlQuery, $check)) {
				// Check if the signature is set to ignored
				if(in_array($key, $whitelistSigkeys)) {
					return false;
				} else {
					$return['signature']= "SIG[".$key."]";
					$return['target']= $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
					$this->target= $return['target'];
					return $return;
				}
			}
		}
		return false;
	}
	private function layer2Detect() {
		$request= array('GET' => $_GET, 'POST' => $_POST, 'COOKIE' => $_COOKIE);
		foreach($request as $key => $value) {
			self :: layer2DetectIterate($key, $value);
		}
	}
	private function layer2DetectIterate($key, $value, $priKey=null, $secKey=null) {
		if(!is_array($value)) {
			if(is_string($value)) {
				self :: layer2DetectAttack($key, $value, $priKey, $secKey);
			} else {
				return false;
			}
		} else {
			foreach($value as $subKey => $subValue) {
				self :: layer2DetectIterate($key.'.'.$subKey, $subValue,$key, $subKey);
			}
		}
	}
	private function layer2DetectAttack($key, $value, $priKey=null, $secKey=null) {
		// 0 - ignore; 1- scan and block; 2 - scan and filter;
		$WhitelistPatternKeys= self :: getWhitelistPatternKeys(0);
		// isn't alphanumeric
		if(!$value || !preg_match('/[^\w\s\/@!?,\.]+|(?:\.\/)|(?:@@\w+)/', $value)) {
			return false;
		}
		// check if this field is part of the exceptions
		if(is_array($WhitelistPatternKeys) && in_array($key, $WhitelistPatternKeys, true)) {
			return false;
		}
		// check for magic quotes and remove them if necessary
		if(function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()) {
			$value= stripslashes($value);
		}
		require_once(dirname(__FILE__).OSEDS.'library'.OSEDS.'Converter.php');
		$value= IDS_Converter :: runAll($value, $this);
		$value= $this->runCentrifuge?IDS_Converter :: runCentrifuge($value, $this): $value;
		// scan keys if activated via config
		if (!isset($this->scankey))
		{
			$this->scankey = false;
		}
		if (!isset($this->scankeyLength))
		{
			$this->scankeyLength = 100;
		}
		$key= $this->scankey ? IDS_Converter :: runAll($key, $this) : $key;
		$key= $this->scankey ? IDS_Converter :: runCentrifuge($key, $this) : $key;
		if ($this->scankey==true)
		{
			if (strlen($key) > $this->scankeyLength)
			{
				self::show403('Illegal Key detected.');
			}
		}

		// scan value against Patterns;
		require_once(dirname(__FILE__).OSEDS.'library'.OSEDS.'Storage.php');
		$filters= array();
		$this->storage= new IDS_Filter_Storage();
		$filterSet= $this->storage->getFilterSet();
		$i= 0;
		foreach($filterSet as $filter) {
			/*
			* in case we have a tag array specified the IDS will only
			* use those filters that are meant to detect any of the
			* defined tags
			*/
			if (!isset($this->l2rulesConf[$filter->id]))
			{
				$this->l2rulesConf[$filter->id] = true;
			}
			if ($this->l2rulesConf[$filter->id]==true)
			{
				if(is_array($this->tags)) {
					if(array_intersect($this->tags, $filter->getTags())) {
						self :: patternMatch($key, $value, $filter);
					}
				} else {
					self :: patternMatch($key, $value, $filter);
				}
			}
			$i++;
		}
		self :: convertVariableValue($priKey, $secKey , $value);
		unset($filterSet);
		unset($key);
		unset($value);
		unset($WhitelistPatternKeys);
	}
	private function convertVariableValue($priKey, $secKey , $value)
	{
		$priKey[$secKey] = $value;
	}
	private function patternMatch($key, $value, $filter) {
		$match= false;
		$urlQuery= htmlspecialchars(str_replace(array("%3C", "%3E", "%5C"), array("<", ">", "\\"), $_SERVER['QUERY_STRING']));
		if($this->scankey == true) {
			if($filter->match($key)) {
				$this->layer2Detected['MalformedKey']['filtersID']=(empty($this->layer2Detected[$key]['filtersID'])) ? $filter->id : $this->layer2Detected[$key]['filtersID'].", ".$filter->id;
				$this->layer2Detected['MalformedKey']['impact']=(empty($this->layer2Detected[$key]['impact'])) ? $filter->impact : $this->layer2Detected[$key]['impact'] + $filter->impact;
				$this->layer2Detected['MalformedKey']['value']= $value;
				$this->layer2Detected['MalformedKey']['target']= $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'].$urlQuery;
				$this->target= $_SERVER['REQUEST_URI'].$urlQuery;
			}
		}
		if($filter->match($value)) {
			$this->layer2Detected[$key]['filtersID']=(empty($this->layer2Detected[$key]['filtersID'])) ? $filter->id : $this->layer2Detected[$key]['filtersID'].", ".$filter->id;
			$this->layer2Detected[$key]['impact']=(empty($this->layer2Detected[$key]['impact'])) ? $filter->impact : $this->layer2Detected[$key]['impact'] + $filter->impact;
			$this->layer2Detected[$key]['value']= $value;
			$this->layer2Detected[$key]['target']= $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'].$urlQuery;
			$this->target= $_SERVER['REQUEST_URI'].$urlQuery;
		}
		return;
	}
	private function trimAttack($signature, $target, $targetid=null) {
		//$mainframe= & JFactory :: getApplication();
		$layer1Rules= self :: getLayer1Signatures();
		$signature= $layer1Rules[str_replace(array("SIG[", "]"), "", $signature)];
		$db= $this->db;
		if(!empty($targetid))
		{
			$value = array();
			$value[] = "`trimmed_value` = ".$db->Quote($signature, true);
			self::updateTarget('l1', $value, $targetid);
		}
		$redirect=((!empty($_SERVER['HTTPS'])) ? "https://" : "http://").str_replace($signature, "", $target);
		header('Location: '.$redirect);
	}
	private function filterAttack($key, $value, $filtersID, $filterlevel,$targetid=null) {
		if (file_exists(dirname(__FILE__).OSEDS.'library'.OSEDS.'htmlpurifier'.OSEDS.'HTMLPurifier.includes.php'))
		{
			require_once(dirname(__FILE__).OSEDS.'library'.OSEDS.'htmlpurifier'.OSEDS.'HTMLPurifier.includes.php');
		}
		else
		{
			require_once(dirname(__FILE__).OSEDS.'library'.OSEDS.'hp'.OSEDS.'HTMLPurifier.includes.php');
		}
		$db= $this->db;
		$htmlPurifier= new HTMLPurifier();
		if($filterlevel >= 2) {
			$value= $htmlPurifier->purify($value);
		}
		if($filterlevel == 4) {
			$filtersIDs= explode(",", $filtersID);
			$filterSet= $this->storage->getFilterSet();
			foreach($filtersIDs as $filtersID) {
				$value= preg_replace('/'.$filterSet[$filtersID -1]->rule.'/ms', '', $value);
			}
		}
		if(!empty($targetid))
		{
			$array = array();
			$array[] = "`trimmed_value` = ".$db->Quote($value, true);
			self::updateTarget('l2', $array, $targetid);
		}
		$key= explode(".", $key);
		switch($key[0]) {
			case "GET" :
				$_GET[$key[1]]= $value;
				break;
			case "POST" :
				$_POST[$key[1]]= $value;
				break;
			case "COOKIE" :
				$_COOKIE[$key[1]]= $value;
				break;
		}
	}
	private function addBlacklistedIP($attackType, $attackAction = null) {
		require_once (OSE_ADMINPATH.OSEDS.'components'.OSEDS.'com_ose_cpu'.OSEDS.'ipmanager'.OSEDS.'ipmanager.php');
		$ipmanager= new oseIpmanager();
		$userid= 0;
		if (class_exists("JConfig"))
		{
			$user= & JFactory :: getUser();
			if($user->id) {
				$userid= $user->id;
			}
		}
		$data['iptype']= 'ip';
		$timestamp= date("ymdhis").mt_rand(10, 99);
		$data['title']= implode(" + ", $attackType)." "."Rules"."[{$timestamp}]";
		$data['status']= (empty($attackAction))?'1':$attackAction;
		$db= $this->db;
		$query= "SELECT * FROM `#__oseipm_iptable` WHERE `ip`=".$db->Quote($this->ip);
		$db->setQuery($query);
		$result= $db->loadObject();
		if(empty($result)) {
			$acl_id= $ipmanager->insertACL($data);
		} else {
			$acl_id= $this->json->encode($result->acl_id);
			$ipmanager->updateACL($acl_id, $data['status'], false);
		}
		$acl_id= $this->json->decode($acl_id);
		$acl_id= (int) $acl_id;
		$iptable_id= $ipmanager->checkIP($this->ip);
		if(empty($iptable_id)) {
			$ipmanager->insertIP($acl_id, $this->ip, $userid);
		} else {
			$ipmanager->updateIP($acl_id, $this->ip, $userid, $iptable_id);
		}
		return $acl_id;
	}
	private function send_email($ipStatus, $attackType, $acl_id, $targetid, $totalImpact) {
		$attackType = implode(",", $attackType);
		switch($ipStatus) {
			case('1') :
				$subject= "OSE Anti-Hacker (TM) Alert for [".$_SERVER['HTTP_HOST']."]";
				$msg = "An attack attempt was logged on ".$this->logtime.".\n\n";
				$msg .= "Alert Type: Detected Attacks are blocked \n";
				$msg .= "IP Address: ".$this->ip."\n";
				$msg .= "URL: ".$this->target."\n";
				$msg .= "Referer (if any): ".$this->referer."\n";
				$msg .= "Attack Type: ".$attackType."\n";
				$msg .= "Blacklisted IP Rule ID: ".$acl_id."\n";
				$msg .= "Total Impact: ".$totalImpact."\n";
				$msg .= "If this blocks your users by mistake, please consult OSE support team for advices."."\n";
				$msg .= "__________________________\n";
				$msg .= "OSE Anti-Hacker™ Security Alert";
				break;
			case('2') :
			case('4') :
				$subject= "OSE Anti-Hacker (TM) for [".$_SERVER['HTTP_HOST']."]";
				$msg = "An attack attempt was filtered on ".$this->logtime.".\n\n";
				$msg .= "Alert Type: Detected Variables are filtered \n";
				$msg .= "IP Address: ".$this->ip."\n";
				$msg .= "URL: ".$this->target."\n";
				$msg .= "Referer (if any): ".$this->referer."\n";
				$msg .= "Attack Type: ".$attackType."\n";
				$msg .= "Blacklisted IP Rule ID: ".$acl_id."\n";
				$msg .= "Total Impact: ".$totalImpact."\n";
				$msg .= "If this filters your values by mistake, please configure the key to ignore or contact OSE Support team."."\n";
				$msg .= "__________________________\n";
				$msg .= "OSE Anti-Hacker™ Security Alert";
				break;
			case('3') :
				$subject= "OSE Anti-Hacker (TM) for [".$_SERVER['HTTP_HOST']."]";
				$msg = "An attack attempt was stopped on ".$this->logtime.".\n\n";
				$msg .= "Alert Type: Detected Attack is stopped by a 403 error page \n";
				$msg .= "IP Address: ".$this->ip."\n";
				$msg .= "URL: ".$this->target."\n";
				$msg .= "Referer (if any): ".$this->referer."\n";
				$msg .= "Attack Type: ".$attackType."\n";
				$msg .= "Blacklisted IP Rule ID: ".$acl_id."\n";
				$msg .= "Total Impact: ".$totalImpact."\n";
				$msg .= "If this stops your PHP application by mistake, please configure the key to ignore or contact OSE Support team."."\n";
				$msg .= "__________________________\n";
				$msg .= "OSE Anti-Hacker™ Security Alert";
				break;
		}

		$db= $this->db;

		if (class_exists("SConfig"))
		{
			$query = " SELECT u.email FROM `#__users` AS u "
					." WHERE gid IN ( 25 ) AND sendEmail =1"
					;
		}
		else
		{
			jimport( 'joomla.version' );
			$version = new JVersion();
			$version = substr($version->getShortVersion(),0,3);

			if($version == '1.5')
			{
				$query = " SELECT u.email FROM `#__users` AS u "
						." WHERE gid IN ( 25 ) AND sendEmail =1"
						;
			}
			else
			{
				$query = " SELECT u.email FROM `#__users` AS u "
						." INNER JOIN `#__user_usergroup_map` AS g ON g.user_id = u.id"
						." WHERE g.group_id IN ( 8 )  AND sendEmail =1"
						;
			}
		}
		//$query = " SELECT email FROM `#__users` WHERE gid =25 AND sendEmail =1";
		$db->setQuery($query);
		$results= $db->loadAssocList();

		if (class_exists("JFactory"))
		{
			$mail = &JFactory::getMailer();
			foreach($results as $result) {
				$mail->addRecipient($result['email']);
			}
			$mail->setSubject($subject);
			$mail->setBody($msg);
			$mail->IsHTML(true);
			$mail->Send();
		}
		else
		{
			if (class_exists("JConfig"))
			{
				$config_var = new JConfig();
			}
            elseif (class_exists("SConfig"))
            {
            	$config_var = new SConfig();
            }
            $MailFrom = $config_var->mailfrom;
            $FromName = $config_var->fromname;
            $headers = "From: " . $FromName . " <" . $MailFrom . ">\n";
            $headers .= "Reply-To: <" . $MailFrom . ">\n";
            $headers .= "Return-Path: <" . $MailFrom . ">\n";
            $headers .= "Envelope-from: <" . $FromName . ">\n";
            $headers .= "Content-Type: text/plain; charset=UTF-8\n";
            $headers .= "MIME-Version: 1.0\n";
            foreach ($results as $result)
            {
                mail($result['email'], $subject, $msg, $headers);
            }
		}
	}
	function getStat() {
		$path= OSEREGISTER_DEFAULT_PATH.OSEDS.'antihacker'.OSEDS.'stat.php';
		if(JFile :: exists($path)) {
			require_once($path);
			static $instance;
			if(!$instance instanceof oseAntihackerStat) {
				$instance= new oseAntihackerStat();
			}
			return $instance;
		} else {
			oseExit('Cannot get the Class of oseAntihackerStat');
		}
	}
	function getSysSetting() {
		$path= dirname(__FILE__).OSEDS.'setting.php';
		if(file_exists($path)) {
			require_once($path);
			static $instance;
			if(!$instance instanceof oseAntihackerSysSetting) {
				$instance= new oseAntihackerSysSetting();
			}
			return $instance;
		} else {
			oseExit('Cannot get the Class of oseAntihackerConfig');
		}
	}
	function show403($message)
	{
		header('HTTP/1.1 403 Forbidden');
				echo("<html>
				<head>
					<title>403 Forbidden</title>
				</head>
				<body>
				<p>{$message}</p>
				</body>
				</html>");
		exit;
	}
	private function getMimeType($filename)
    {
       if (function_exists('finfo_open'))
         {
            $finfo = finfo_open(FILEINFO_MIME_TYPE); // return mime type ala mimetype extension
            $content_type = finfo_file($finfo, $filename);
             finfo_close($finfo);
             return $content_type;
         }
       else
        {
            self::show403('Finfo is not compiled in your PHP, file type validation function cannot work on your server. Please go to OSE Security backend and remove the file types.');
        }
    }
   private function checkFileTypes($files)
	{
		if(!empty($this->allowExts))
		{
			foreach($files as $file)
			{
				if(!empty($file['tmp_name']))
				{
					$mimeType= self :: getMimeType($file['tmp_name']);
					$mimeType= explode("/", $mimeType);
					$ext= explode('/', $file['type']);
					$allowExts= explode(",", $this->allowExts);
					if($ext[1] != $mimeType[1])
					{
						$acl_id= self :: addBlacklistedIP(array('L3'));
						self :: send_email('1', array('L3 - Inconsistent File Type'), $acl_id, '', '100');
						self :: show403('Malicious file type detected. Your action has been reported to the server administrator');
					}
					elseif(!in_array($mimeType[1], $allowExts))
					{
						self :: show403('The upload of this file type is not allowed this website. If you are the server administrator, please add the extensions in the configuraiton in OSE Security first.');
					}
				}
			}
		}
	}
	private function scanFileVirus($files)
	{
		if(!empty($this->scanFileVirus))
		{
			if(file_exists(OSE_ADMINPATH.OSEDS."components".OSEDS."com_ose_cpu".OSEDS."virusscan".OSEDS."virusscan.php"))
			{
				require_once(OSE_ADMINPATH.OSEDS."components".OSEDS."com_ose_cpu".OSEDS."virusscan".OSEDS."virusscan.php");
				if(file_exists(OSE_ADMINPATH.OSEDS."components".OSEDS."com_ose_cpu".OSEDS."filescan".OSEDS."filescan.php"))
				{
					require_once(OSE_ADMINPATH.OSEDS."components".OSEDS."com_ose_cpu".OSEDS."filescan".OSEDS."filescan.php");
				}
				$virScanClass= new oseVirusscan();
				$virScan= $virScanClass->getInstance();
				foreach($files as $file)
				{
					if(!empty($file['tmp_name']))
					{
						$scanResult= $virScan->virusScan($file['tmp_name']);
						if($scanResult == true)
						{
							$acl_id= self :: addBlacklistedIP(array('L3-Virus'));
							$targetid['l1'][]= self :: insertTarget('l4', 'virus', $this->url);
							$totalImpact= 100;
							unset($_FILES);
							if(!empty($acl_id))
							{
							  if(self :: logAttack($acl_id, $targetid, $totalImpact))
							 {
							 	self :: send_email('1', array('Virus File Upload Attempt'), $acl_id, '', '100');
							 	self :: show403('Malicious file type detected. Your action has been reported to the server administrator');
							 }
						   }
						}
					}
				}
			}
		}
	}
	private function scanFlooding($decduration= 10, $maxvisits= 5)
	{
		require_once(dirname(__FILE__).OSEDS.'library'.OSEDS.'addons.php');
		$result= OSEAH_Addons :: floodingCheck($decduration, $maxvisits, $this->ip, $this->db);
		if($result == true)
		{
			$acl_id= self :: addBlacklistedIP(array('L4'));
			$targetid['l1'][]= self :: insertTarget('l4', 'flooding', $this->url);
			$totalImpact= 100;
			if(!empty($acl_id))
			{
				if(self :: logAttack($acl_id, $targetid, $totalImpact))
				{
					self :: send_email('1', array('L4 - Flooding'), $acl_id, '', '100');
					self :: showBanPage();
				}
			}
		}
	}
	private function updateTarget($type, $value=array(), $targetid) {
		$db= $this->db;
		$value = implode(',',$value);
		if($type == 'l1') {
			$query= "UPDATE `#__oseath_l1rules` ".	"SET  ".$value." WHERE `id` = '{$targetid}'";
		} else {
			$query= "UPDATE `#__oseath_l2rules` ".	"SET  ".$value." WHERE `id` = '{$targetid}'";
		}
		$db->setQuery($query);
		if($db->query()) {
			return true;
		} else {
			return false;
		}
	}
	public function getRemoteScan($_POST){
		$path= dirname(__FILE__).OSEDS.'remote.php';
		if(file_exists($path)) {
			require_once($path);
			static $instance;
			if(!$instance instanceof oseAntihackerRemote) {
				$instance= new oseAntihackerRemote($_POST);
			}
			return $instance;
		} else {
			oseExit('Cannot get the Class of oseAntihackerStat');
		}
	}
}
?>