<?php
/**
  * @version     3.0 +
  * @package       Open Source Excellence Security Suite
  * @subpackage    Open Source Excellence CPU
  * @author        Open Source Excellence {@link http://www.opensource-excellence.com}
  * @author        Created on 30-Sep-2010
  * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
  *
  *
  *  This program is free software: you can redistribute it and/or modify
  *  it under the terms of the GNU General Public License as published by
  *  the Free Software Foundation, either version 3 of the License, or
  *  (at your option) any later version.
  *
  *  This program is distributed in the hope that it will be useful,
  *  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *  GNU General Public License for more details.
  *
  *  You should have received a copy of the GNU General Public License
  *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  *  @Copyright Copyright (C) 2008 - 2010- ... Open Source Excellence
*/
defined('_JEXEC') or die("Direct Access Not Allowed");
include(JPATH_ADMINISTRATOR.DS.'components/com_ose_antivirus/views/scan/tmpl/js.php');
?>
<input type="hidden" id='vstotal' value = '<?php echo $this->vstotal; ?>'/>
<div id='center-heading' class='ch-heading'>
<?php echo JText::_('Virus Scanning and Removal') ?>
</div><br />
<div id="vs-notice" class="notice">
<?php
if (!empty($this->vstotal))
{
	if (!empty($this->exts))
	{
		echo JText::_("There are in total of")." ".$this->vstotal." ". JText::_("files in the database. If you would like to scan other files / folders, please access the ")."<a href='index.php?option=com_osefileman'>OSE File Manager</a> ". JText::_("and select folders to be scanned.");
	}
	else
	{
		echo JText::_('Please select file extensions before scanning.');
	}
}
else
{
	echo JText::_('Please perform database initialisation before performing file auditing and virus scanning.');
}
?>
</div>

<?php
// Show Configuration Panel in the following;
?>
<div id='filescanning'>
<div class='center-setting' >
<div class='info'>
<?php echo JText::_('Folders and files being scanned'); ?>
</div>
<div class='setting' id='fssetting'>
<?php
$currentSession = JSession::getInstance('oseantivirus',array());
$scanInfo = $currentSession->get("scanInfo");
if (empty($scanInfo))
{
	echo JText::_("There are no files selected to be scanned. Please access ")." <a href='index.php?option=com_osefileman'>OSE File Manager</a> ". JText::_("and select folders to be scanned.");
}
else
{
?>
	<div class='selectedFolders'>
		<?php
		   echo "<ul>";
		   foreach ($scanInfo['selected'] as $selected)
		   {$selected = str_replace("+", " ", $selected);
			echo "<li>".$scanInfo['parent'].DS.$selected."</li>";
		   	echo '<input type="hidden" value="'.$scanInfo['parent'].DS.$selected.'" name ="selected[]" id ="selected[]">';
		   }
		   echo "</ul>";
		?>
	</div>
	<div id='loadingindicator'></div>
<?php
}
?>
</div>
<div id='fspbar'></div>
<div id='fsinfo'></div>
</div>
</div>

<div id='virusscanning'>
<div class='center-setting' >
<div class='info'>
<?php echo JText::_('Configuration'); ?>
</div>

<div class='setting' id='vssetting'>
<dl>
<dt class='content'>
<?php
if (!empty($this->exts))
{
	$exts = implode(",", $this->exts);

	echo "<div id='cur_exts'><b>".JText::_('Current file extensions include:</b>')." ". $exts.'</div>';
}
else
{
	echo '<span id="cur_exts" class="warning">'.JText::_('File extensions are not defined. Please define it in the following configuration section.')."</span>";
}
?>
</dt>
<dt class='content'>
<?php echo "<b>".JText::_('Please configurate the file extensions here:</b>')." ";
?>
<br />
<table width="100%" class="exts">
<tr class="odd">
<td width="15%" class='heading'><?php echo JText::_("HTML files"); ?></td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[htm]" value="htm" <?php echo (!empty($this->exts) && in_array('htm', $this->exts))?"checked":""; ?>/> htm</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[html]" value="html" <?php echo (!empty($this->exts) && in_array('html', $this->exts))?"checked":""; ?>/> html</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[shtm]" value="shtm" <?php echo (!empty($this->exts) && in_array('shtm', $this->exts))?"checked":""; ?>/> shtm</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[shtml]" value="shtml" <?php echo (!empty($this->exts) && in_array('shtml', $this->exts))?"checked":""; ?>/> shtml</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[css]" value="css" <?php echo (!empty($this->exts) && in_array('css', $this->exts))?"checked":""; ?>/> css</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[js]" value="js" <?php echo (!empty($this->exts) && in_array('js', $this->exts))?"checked":""; ?>/> js</td>
</tr>
<tr class="even">
<td width="15%" class='heading'><?php echo JText::_("PHP files"); ?></td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[php]" value="php" <?php echo (!empty($this->exts) && in_array('php', $this->exts))?"checked":""; ?>/> php</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[php3]" value="php3" <?php echo (!empty($this->exts) && in_array('php3', $this->exts))?"checked":""; ?>/> php3</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[php4]" value="php4" <?php echo (!empty($this->exts) && in_array('php4', $this->exts))?"checked":""; ?>/> php4</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[php5]" value="php5" <?php echo (!empty($this->exts) && in_array('php5', $this->exts))?"checked":""; ?>/> php5</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[inc]" value="inc" <?php echo (!empty($this->exts) && in_array('inc', $this->exts))?"checked":""; ?>/> inc</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[phtml]" value="phtml" <?php echo (!empty($this->exts) && in_array('phtml', $this->exts))?"checked":""; ?>/> phtml</td>
</tr>
<tr class="odd">
<td width="15%" class='heading'><?php echo JText::_("Images files"); ?></td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[jpg]" value="jpg" <?php echo (!empty($this->exts) && in_array('jpg', $this->exts))?"checked":""; ?>/> jpg</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[jpeg]" value="jpeg" <?php echo (!empty($this->exts) && in_array('jpeg', $this->exts))?"checked":""; ?>/> jpeg</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[gif]" value="gif" <?php echo (!empty($this->exts) && in_array('gif', $this->exts))?"checked":""; ?>/> gif</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[png]" value="png" <?php echo (!empty($this->exts) && in_array('png', $this->exts))?"checked":""; ?>/> png</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[bmp]" value="bmp" <?php echo (!empty($this->exts) && in_array('bmp', $this->exts))?"checked":""; ?>/> bmp</td>
<td></td>
</tr>
<tr class="even">
<td width="15%" class='heading'><?php echo JText::_("Server files"); ?></td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[c]" value="c" <?php echo (!empty($this->exts) && in_array('c', $this->exts))?"checked":""; ?>/> c</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[sh]" value="sh" <?php echo (!empty($this->exts) && in_array('sh', $this->exts))?"checked":""; ?>/> sh</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[pl]" value="pl" <?php echo (!empty($this->exts) && in_array('pl', $this->exts))?"checked":""; ?>/> pl</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[perl]" value="perl" <?php echo (!empty($this->exts) && in_array('perl', $this->exts))?"checked":""; ?>/> perl</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[cgi]" value="cgi" <?php echo (!empty($this->exts) && in_array('cgi', $this->exts))?"checked":""; ?>/> cgi</td>
<td width="15%" ><input type="checkbox" name="file_ext[]" id="file_ext[txt]" value="txt" <?php echo (!empty($this->exts) && in_array('txt', $this->exts))?"checked":""; ?> /> txt</td>
</tr>
</table>
<button id="vscfgupdate" class='button'><?php echo JText::_('Update File Extensions') ?></button>
</dt>
</dl>
</div>
</div>

<div class='center-content' id='vscp'>
<div class='info' id='vs-info'>
<?php

?>
</div>
<!-- Action Panel -->
<div class='action_panel'>
   <div class='action_button'>
   <button id="scanresults" class='button'><?php echo JText::_('View Scanning Results') ?></button>
   <button id="stopvscan" class='button'><?php echo JText::_('Stop Virus Scanning') ?></button>
   <button id="startvscan" class='button'><?php echo JText::_('Start Virus Scanning') ?></button>
   <button id="init" class='button'><?php echo JText::_('Initialise Database') ?></button>
   </div>
   <div class='action_progress'>
   <div id="vspbar"></div>
   <span id="vspbartext">Ready</span>
   </div>
</div>
<?php
echo "<div class='stat_panel'>";
echo "<div class='stat_heading'>".JText :: _("Statistics:")." ".JText :: _("Last scanning Time:")."<span id='lstime'> ".$this->LastScanLog['lstime']."</span>. Results: <span id='lsresults'>".$this->LastScanLog['lsresults']." </span></div>";
echo "<div class='stat'>".JText :: _("Number of clean files in the last scanning:")."<span id='lsclean'> ".$this->LastScanLog['lsclean']." </span></div>";
echo "<div class='stat'>".JText :: _("Number of infected files in the last scanning")."<span id='lsinfected'> ".$this->LastScanLog['lsinfected']." </span></div>";
?>
</div>
</div>