<?php
/**
  * @version     3.0 +
  * @package       Open Source Excellence Security Suite
  * @subpackage    Open Source Excellence CPU
  * @author        Open Source Excellence {@link http://www.opensource-excellence.com}
  * @author        Created on 30-Sep-2010
  * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
  *
  *
  *  This program is free software: you can redistribute it and/or modify
  *  it under the terms of the GNU General Public License as published by
  *  the Free Software Foundation, either version 3 of the License, or
  *  (at your option) any later version.
  *
  *  This program is distributed in the hope that it will be useful,
  *  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *  GNU General Public License for more details.
  *
  *  You should have received a copy of the GNU General Public License
  *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  *  @Copyright Copyright (C) 2008 - 2010- ... Open Source Excellence
*/
defined( '_JEXEC' ) or die( ';)' );
jimport('joomla.application.component.controller');

/**
 * ssrrn_acl Controller
 *
 * @package    ssrrn_acl
 * @subpackage Controllers
 */
class ose_antivirusControllerreport extends ose_antivirusController
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	function __construct()
	{
		parent::__construct();
	}// function

	function getInfected()
	{
		$virScan = oseRegistry::call('virusscan');
		$VSa= $virScan->getDefs();
		$VSb= $virScan->getPatternExp();
		$VSPatterns = array_merge($VSa, $VSb);
		unset($VSa);
		unset($VSb);
		$records = $virScan->getStat()->getResult();
		$results = array();
		$dir_above = substr( JPATH_ROOT, 0, strrpos( JPATH_ROOT, DS ));
		if( !@is_readable($dir_above) || !is_dir($dir_above) ) {
		$rootPath= JPATH_ROOT;
		}
		else {
		$rootPath= $dir_above;
		}
		unset($dir_above);
		$i = 0 ;
		foreach ($records as $record)
		{
			$results[$i]->id = $record->id;
			$virus= explode(",", $record->virus);
			if ($virus[0]!='type3')
			{
				$results[$i]->virus = $VSPatterns[$virus[0]][$virus[1]];
				$results[$i]->virus="[O]".$results[$i]->virus[0];
			}
			else
			{
				$results[$i]->virus = "[C]".$virus[1];
			}
			$results[$i]->filepath = $record->filepath;
			$file = str_replace($rootPath, '', $results[$i]->filepath);
			$file = str_replace("\\", "\\\\", $file);
			//$results[$i]->view = "<input type='image' src='components/com_ose_antivirus/assets/images/page_white_magnify.png' onClick='openFile({$file})'>";
			$results[$i]->view = "<a href='index.php?option=com_osefileman&action=edit&dir=&order=name&srt=yes&item=".urlencode($file)."' class='modal' rel=\"{handler: 'iframe', size: {x: 980, y: 500}}\" target='_blank'><img src='components/com_ose_antivirus/assets/images/page_white_magnify.png' /></a>";
			$i++;
		}

		$return['results'] = $results;
		$return['total'] = $virScan->getStat()->getDetectedTotal();
		echo oseJSON::encode($return);
		exit;
	}
	function getFileContent()
	{
		$id = JRequest::getInt('recordid');
		$db = &JFactory::getDBO();
		$query = "SELECT filepath FROM `#__oseav_detected` WHERE id =".(int)$id;
		$db->setQuery($query);
		$file = $db->loadResult();

		$dir_above = substr( JPATH_ROOT, 0, strrpos( JPATH_ROOT, DS ));

		if( !@is_readable($dir_above) || !is_dir($dir_above) ) {
		$rootPath= JPATH_ROOT;
		}
		else {
		$rootPath= $dir_above;
		}
		$file = str_replace($rootPath, '', $file);
		$content ='';
		$return['content'] = $content;
		echo oseJSON::encode($return);
		exit;
	}
}