<?php
/**
  * @version     3.0 +
  * @package       Open Source Excellence Security Suite
  * @subpackage    Open Source Excellence CPU
  * @author        Open Source Excellence {@link http://www.opensource-excellence.com}
  * @author        Created on 30-Sep-2010
  * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
  *
  *
  *  This program is free software: you can redistribute it and/or modify
  *  it under the terms of the GNU General Public License as published by
  *  the Free Software Foundation, either version 3 of the License, or
  *  (at your option) any later version.
  *
  *  This program is distributed in the hope that it will be useful,
  *  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *  GNU General Public License for more details.
  *
  *  You should have received a copy of the GNU General Public License
  *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  *  @Copyright Copyright (C) 2008 - 2010- ... Open Source Excellence
*/
defined('_JEXEC') or die("Direct Access Not Allowed");
?>
<script type="text/javascript" >
Ext.ns('oseATH','oseATHReportL2');
oseATH.msg = new Ext.App();
function viewdetail(id)
{
	var win = new Ext.Window({
			id:'attackdetail',
			title: 'Attack information',
            layout:'fit',
            width:1024,
            height:500,
            closeAction:'close',
            closable:'true',
            collapsible:'true',
            autoScroll:'true'
	})

	Ext.Ajax.request({
				url : 'index.php' ,
				params : {
					option : 'com_ose_antihacker',
					task:'viewAttackDetail',
					controller:'report',
					id: id,
					layer: 'l2'
				},
				method: 'POST',
				success: function ( result, request ) {
					msg = Ext.decode(result.responseText);
					if (msg.status!='ERROR')
					{
						win.show();
						win.update(msg.result);
					}
					else
					{
						Ext.Msg.alert('ERROR');
					}
				}
		});
}
Ext.onReady(function(){
		oseATHReportL2.cm = new Ext.grid.ColumnModel({
        defaults: {
            sortable: false
        },
        columns: [
            new Ext.grid.RowNumberer({header:'#'})
            ,{id: 'id', header: 'ID',  hidden:false, dataIndex: 'id', width: 20, sortable:true}
            ,{id: 'key', header: 'Signature',  hidden:false, dataIndex: 'key', sortable:true}
            ,{id: 'keyaction', header: 'Signature Action',  hidden:false, dataIndex: 'keyaction', sortable:true}
            ,{id: 'target', header: 'Target',  hidden:false, dataIndex: 'target', sortable:true}
            ,{id: 'targetaction', header: 'Target Action',  hidden:false, dataIndex: 'targetaction', sortable:true}
            ,{id: 'view', header: 'View Detail',  hidden:false, dataIndex: 'view', width: 20}
	    ],
	    sortInfo:{field: 'id', direction: "ASC"}
    });

		oseATHReportL2.store = new Ext.data.GroupingStore({
		  proxy: new Ext.data.HttpProxy({
	            url: 'index.php?option=com_ose_antihacker&controller=report',
	            method: 'POST'
	      }),
		  baseParams:{task: "getlayer2AttackList",limit: 25},
		  reader: new Ext.data.JsonReader({
		    root: 'results',
		    totalProperty: 'total'
		  },[
		    {name: 'id', type: 'int', mapping: 'id'},
		    {name: 'key', type: 'string', mapping: 'key'},
		    {name: 'keyaction', type: 'string', mapping: 'keyaction'},
		    {name: 'target', type: 'string', mapping: 'target'},
		    {name: 'targetaction', type: 'string', mapping: 'targetaction'},
		    {name: 'view', type: 'string', mapping: 'view'}
		  ]),
		  groupField:'key',
		  autoLoad:{}
	});

    oseATHReportL2.filters = new Ext.ux.grid.GridFilters({
        encode: true,
        local: false,
        filters: [ {
            type: 'list',
            dataIndex: 'Status',
            options: [[1,'Blacklisted'],[2,'Monitored'], [3,'Whitelisted']],
            phpMode: true
        }]
    });

	oseATH.oseATHReportL2 = new Ext.grid.GridPanel({
		id: 'oseATHReportL2'
		,cm: oseATHReportL2.cm
		,store: oseATHReportL2.store
		,view: new Ext.grid.GroupingView({
			forceFit:true,
	        groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
	 	})
		,viewConfig: {forceFit: true}
		,plugins: [oseATHReportL2.filters]
		,height: 500
		,region: 'west'
		,margins: {top:5, right:5, bottom:5, left:3}
		,tbar: new Ext.Toolbar({
			items: [{
					text: 'Attacks Action'
		    		,menu:[
					    	{
					        	id: 'blKey',
					            text: 'Block Attacks',
					            xtype: 'button',
					            handler: function(){
					            	Ext.Msg.confirm('Block attacks confirmation', 'Please confirm that you would like to block the attacks with the selected key.', function(btn, text){
										if (btn == 'yes'){
											var sel = oseATH.oseATHReportL2.getSelectionModel();
											var selections = sel.getSelections();
											athAjax('com_ose_antihacker','blKey','report', selections);
								      	}
					            	})
					            }
					        },{
					        	id: 'ftKey',
					            text: 'Filter Attacks',
					            xtype: 'button',
					            handler: function(){
					            	Ext.Msg.confirm('Ignore attacks confirmation', 'Please confirm that you would like to ignore the attacks with the selected key.', function(btn, text){
										if (btn == 'yes'){
											var sel = oseATH.oseATHReportL2.getSelectionModel();
											var selections = sel.getSelections();
											athAjax('com_ose_antihacker','ftKey','report', selections);
								      	}
					            	})
					            }
					        }
					        ,{
					        	id: 'wlKey',
					            text: 'Ignore Attacks',
					            xtype: 'button',
					            handler: function(){
					            	Ext.Msg.confirm('Ignore attacks confirmation', 'Please confirm that you would like to ignore the attacks with the selected key.', function(btn, text){
										if (btn == 'yes'){
											var sel = oseATH.oseATHReportL2.getSelectionModel();
											var selections = sel.getSelections();
											athAjax('com_ose_antihacker','wlKey','report', selections);
								      	}
					            	})
					            }
					        }
				           ]
				     },{
						text: 'Targets Action'
					   	,menu:[
					        {
					        	id: 'blTarget',
					            text: 'Monitor Targets',
					            xtype: 'button',
					            handler: function(){
					            	Ext.Msg.confirm('Monitor target confirmation', 'Please confirm that you would like to monitor the selected target.', function(btn, text){
										if (btn == 'yes'){
											var sel = oseATH.oseATHReportL2.getSelectionModel();
											var selections = sel.getSelections();
											athAjax('com_ose_antihacker','blTargetlayer2','report', selections);
								      	}
					            	})
					            }
					        },{
					        	id: 'wlTarget',
					            text: 'Ignore Targets',
					            xtype: 'button',
					            handler: function(){
					            	Ext.Msg.confirm('Ignore target confirmation', 'Please confirm that you would like to ignore the selected target.', function(btn, text){
										if (btn == 'yes'){
											var sel = oseATH.oseATHReportL2.getSelectionModel();
											var selections = sel.getSelections();
											athAjax('com_ose_antihacker','wlTargetlayer2','report', selections);
								      	}
					            	})
					            }
					        },{
					        	id: 'ftTarget',
					            text: 'Gently Filter Targets',
					            xtype: 'button',
					            handler: function(){
					            	Ext.Msg.confirm('Filter target confirmation', 'Please confirm that you would like to filter the selected target.', function(btn, text){
										if (btn == 'yes'){
											var sel = oseATH.oseATHReportL2.getSelectionModel();
											var selections = sel.getSelections();
											athAjax('com_ose_antihacker','ftTargetlayer2','report', selections);
								      	}
					            	})
					            }
					        },{
					        	id: 'ftTarget2',
					            text: 'Strictly Filter Targets',
					            xtype: 'button',
					            handler: function(){
					            	Ext.Msg.confirm('Filter target confirmation', 'Please confirm that you would like to filter the selected target.', function(btn, text){
										if (btn == 'yes'){
											var sel = oseATH.oseATHReportL2.getSelectionModel();
											var selections = sel.getSelections();
											athAjax('com_ose_antihacker','ftTargetlayer4','report', selections);
								      	}
					            	})
					            }
					        }
					     ]
				     },{
				        	id: 'removeRules',
				            text: 'Remove',
				            xtype: 'button',
				            handler: function(){
				            	Ext.Msg.confirm('Remove Record confirmation', 'Please confirm that you would like to remove the selected record.', function(btn, text){
									if (btn == 'yes'){
										var sel = oseATH.oseATHReportL2.getSelectionModel();
										var selections = sel.getSelections();
										athAjax('com_ose_antihacker','removeL2rules','report', selections);
							      	}
				            	})
				            }
				        },
				        '->','Search',
				        new Ext.ux.form.SearchField({
			                store: oseATHReportL2.store,
			                paramName: 'search'
			            })
				    ]
		})
		,bbar:new Ext.PagingToolbar({
    		pageSize: 25,
    		store: oseATHReportL2.store,
    		plugins: new Ext.ux.grid.limit({}),
    		displayInfo: true,
		    displayMsg: 'Displaying topics {0} - {1} of {2}',
		    emptyMsg: "No topics to display"

	    })
       });

	    oseATH.oseATHReportL2.panel = new Ext.Panel({
		id: 'oseATHReportL2-panel'
		,border: false
		,layout: 'fit'
		,items:[
			oseATH.oseATHReportL2
		]
		,height: 'auto'
		,width: '100%'
		,renderTo: 'oseantihackerReport'
	});

function athAjax(option, task, controller,selections)
  {
	var i=0;
    ids=new Array();
	for (i=0; i < selections.length; i++)
	{
        ids [i] = selections[i].id;
	}
	ids = Ext.encode(ids);
	// Ajax post scanning request;
	Ext.Ajax.request({
				url : 'index.php' ,
				params : {
					option : option,
					task:task,
					controller:controller,
					ids: ids
				},
				method: 'POST',
				success: function ( result, request ) {
					msg = Ext.decode(result.responseText);
					if (msg.status!='ERROR')
					{
						oseATH.msg.setAlert(msg.status, 'The action '+task+' was executed successfully.');
						oseATHReportL2.store.reload();
					}
					else
					{
						oseATH.msg.setAlert('Error', msg.result);
						oseATHReportL2.store.reload();
					}
				}
			});
	}
})
</script>