<?php
/**
  * @version     3.0 +
  * @package       Open Source Excellence Security Suite
  * @subpackage    Open Source Excellence CPU
  * @author        Open Source Excellence {@link http://www.opensource-excellence.com}
  * @author        Created on 30-Sep-2010
  * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
  *
  *
  *  This program is free software: you can redistribute it and/or modify
  *  it under the terms of the GNU General Public License as published by
  *  the Free Software Foundation, either version 3 of the License, or
  *  (at your option) any later version.
  *
  *  This program is distributed in the hope that it will be useful,
  *  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *  GNU General Public License for more details.
  *
  *  You should have received a copy of the GNU General Public License
  *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  *  @Copyright Copyright (C) 2008 - 2010- ... Open Source Excellence
*/
defined('_JEXEC') or die("Direct Access Not Allowed");
?>
<script type="text/javascript" >
Ext.ns('oseATH','oseATHReport');
Ext.onReady(function(){
	var thresholdSlider = new Ext.Slider ({
			fieldLabel: 'Attack blocking threshold value slider',
	        width: 300,
	        minValue: 0,
	        maxValue: 100,
	        name: 'threshold',
            id: 'threshold',
            isFormField: true,
	        plugins: new Ext.slider.Tip()
	});

    var top = new Ext.FormPanel({
        ref: 'form',
        labelAlign: 'top',
        frame:false,
        bodyStyle:'padding:0px 0px 0',
        autoScroll: true,
        width: 600,
        items: [
		{
        xtype: 'tabpanel'
			,activeItem: 0
			,autoHeight: true
			,autoWidth:true
			,border: false
			,items: [
			   {
				xtype:'fieldset',
				title: 'Search Engine Optimization',
				height: 500,
				items:[
						{   xtype:'textfield',
		                    fieldLabel: 'SEO Page Title',
		                    name: 'pageTitle',
		                    id: 'pageTitle',
		                    anchor:'70%'
		                }
		                ,{
		                    xtype:'textfield',
		                    fieldLabel: 'SEO Meta Keywords',
		                    name: 'metaKeywords',
		                    id: 'metaKeywords',
		                    anchor:'70%'
		                },{
		                    xtype:'textfield',
		                    fieldLabel: 'SEO Meta Description',
		                    name: 'metaDescription',
		                    id: 'metaDescription',
		                    anchor:'70%'
		                },{
		                    xtype:'textfield',
		                    fieldLabel: 'SEO Meta Generator',
		                    name: 'metaGenerator',
		                    id: 'metaGenerator',
		                    anchor:'70%'
		                },{
		                    xtype:'textfield',
		                    fieldLabel: 'Webmaster Contact Email',
		                    name: 'adminEmail',
		                    id: 'adminEmail',
		                    vtype:'email',
		                    allowBlank:false,
		                    anchor:'70%'
		                },{
				            fieldLabel: 'Custom Ban Page',
				            name:'customBanpage',
				            itemId: 'customBanpage',
				            id:'customBanPage',
				            fieldLabel:'Custom BanPage',
				            xtype:'tinymce',
					        width: 800,
				            height:400,
				            tinymceSettings: {
						        theme: "advanced",
						        skin: 'o2k7',
						        plugins: "pagebreak,style,layer,table,advhr,advimage,advlink,emotions,iespell,insertdatetime,preview,media,searchreplace,print,contextmenu,paste,directionality,noneditable,visualchars,nonbreaking,xhtmlxtras,template",
						        theme_advanced_buttons1: "bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,styleselect,formatselect,fontselect,fontsizeselect",
						        theme_advanced_buttons2: "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,|,insertdate,inserttime,preview,|,forecolor,backcolor",
						        theme_advanced_buttons3: "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,emotions,iespell,media,advhr,|,print,|,ltr,rtl,|",
						        theme_advanced_buttons4: "insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,visualchars,nonbreaking,template,pagebreak",
						        theme_advanced_toolbar_location: "top",
						        theme_advanced_toolbar_align: "left",
						        theme_advanced_statusbar_location: "bottom",
						        theme_advanced_resizing: false,
						        extended_valid_elements: "a[name|href|target|title|onclick],img[class|src|border=0|alt|title|hspace|vspace|width|height|align|onmouseover|onmouseout|name|style],hr[class|width|size|noshade],font[face|size|color|style],span[class|align|style]",
						        template_external_list_url: "example_template_list.js"
						    }
		        	  	}
					]
                },
				{
				title: 'Scanning Setting',
				height: 500,
				items:[
						{
						xtype:'fieldset',
						title: 'Frontend Blocking Setting',
						items:[
						{
							hiddenName: 'blockIP'
							,fieldLabel: 'Frontend Blocking Mode'
							,xtype:'combo'
							,typeAhead: true
							,triggerAction: 'all'
							,lazyRender:true
							,mode: 'local'
							,width: 400
							,ListWidth: 500
							,store: new Ext.data.ArrayStore({
							     id: 0
							     ,fields: [
							         'myId'
							         ,'displayText'
							      ]
							 ,data: [
									  	['1', 'Ban IP and show ban page to stop an attack']
							        	,['0', 'Show a 403 error page and stop the attack']
							        	,['2','Silently filter hacking values - Recommended for new users']
							        ]
							    })
							 ,valueField: 'myId'
							 ,displayField: 'displayText'
							 ,listeners:{
									render: function(c){
										if (c.value=='')
										{
										c.setValue('2');
										}
								 }
								}
						},
		                thresholdSlider
						]},

						{
						xtype:'fieldset',
						title: 'File Upload Scanning Options',
						items:[
						{
				               xtype:'textfield',
				               labelWidth: 500,
				               labelAlign: 'left',
				               fieldLabel: 'Allowed Upload File Extensions (Please use a "," to separate each extensions, e.g. jpg,png,doc)',
				               name: 'allowExts',
				               id: 'allowExts',
				               anchor:'98%'
				         },
				         {
		                		xtype: 'radiogroup'
								,name: 'scanFileVirus'
								,id: 'scanFileVirus'
								,fieldLabel: 'Scan uploaded files with OSE Anti-Virus'
								,width: 200
								,defaults:{xtype:'radio',name:'scanFileVirus'}
								,items:[
									{boxLabel: 'Yes', inputValue: 1, checked:true}
									,{boxLabel: 'No', inputValue: 0}
								]
						}
				     ]
				   }
				]
				},
				{
					title: 'Layer 2 Variables Converstion',
					height: 550,
					items:[
					{
							xtype:'fieldset',
							title: 'Layer 2 Variables Conversion Tweaks',
							labelWidth: 500,
							items:[
   								 {
			                		xtype: 'radiogroup'
									,name: 'convertFromRepetition'
									,id: 'convertFromRepetition'
									,fieldLabel: 'Remove Repetition Codes'
									,width: 200
									,defaults:{xtype:'radio',name:'convertFromRepetition'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'convertFromCommented'
									,id: 'convertFromCommented'
									,fieldLabel: 'Remove Comments'
									,width: 200
									,defaults:{xtype:'radio',name:'convertFromCommented'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
					    		{
			                		xtype: 'radiogroup'
									,name: 'convertFromWhiteSpace'
									,id: 'convertFromWhiteSpace'
									,fieldLabel: 'Remove White Space and New Lines'
									,width: 200
									,defaults:{xtype:'radio',name:'convertFromWhiteSpace'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
								{
			                		xtype: 'radiogroup'
									,name: 'convertFromJSCharcode'
									,id: 'convertFromJSCharcode'
									,fieldLabel: 'Convert common JS charcode patterns'
									,width: 200
									,defaults:{xtype:'radio',name:'convertFromJSCharcode'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
								{
			                		xtype: 'radiogroup'
									,name: 'convertJSRegexModifiers'
									,id: 'convertJSRegexModifiers'
									,fieldLabel: 'Remove JS regular expression modifiers'
									,width: 200
									,defaults:{xtype:'radio',name:'convertJSRegexModifiers'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
								{
			                		xtype: 'radiogroup'
									,name: 'convertEntities'
									,id: 'convertEntities'
									,fieldLabel: 'Convert Hex/Dec entities'
									,width: 200
									,defaults:{xtype:'radio',name:'convertEntities'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
								{
			                		xtype: 'radiogroup'
									,name: 'convertQuotes'
									,id: 'convertQuotes'
									,fieldLabel: 'Formalize All Quotes to Double Quotes'
									,width: 200
									,defaults:{xtype:'radio',name:'convertQuotes'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
								{
			                		xtype: 'radiogroup'
									,name: 'convertFromSQLHex'
									,id: 'convertFromSQLHex'
									,fieldLabel: 'Convert and Remove Harmful HEX SQL Query'
									,width: 200
									,defaults:{xtype:'radio',name:'convertFromSQLHex'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
								{
			                		xtype: 'radiogroup'
									,name: 'convertFromControlChars'
									,id: 'convertFromControlChars'
									,fieldLabel: 'Converts malicious unicode characters'
									,width: 200
									,defaults:{xtype:'radio',name:'convertFromControlChars'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
								{
			                		xtype: 'radiogroup'
									,name: 'convertFromNestedBase64'
									,id: 'convertFromNestedBase64'
									,fieldLabel: 'Translates base64 strings and fragments'
									,width: 200
									,defaults:{xtype:'radio',name:'convertFromNestedBase64'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
								{
			                		xtype: 'radiogroup'
									,name: 'convertFromOutOfRangeChars'
									,id: 'convertFromOutOfRangeChars'
									,fieldLabel: 'Converts Out of Range Characters'
									,width: 200
									,defaults:{xtype:'radio',name:'convertFromOutOfRangeChars'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
								{
			                		xtype: 'radiogroup'
									,name: 'convertFromXML'
									,id: 'convertFromXML'
									,fieldLabel: 'Strips HTML tags'
									,width: 200
									,hidden: true
									,defaults:{xtype:'radio',name:'convertFromXML'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1}
										,{boxLabel: 'No', inputValue: 0,checked:true}
									]
							    },
								{
			                		xtype: 'radiogroup'
									,name: 'convertFromJSUnicode'
									,id: 'convertFromJSUnicode'
									,fieldLabel: 'Converts JS Unicode Characters to its Original'
									,width: 200
									,defaults:{xtype:'radio',name:'convertFromJSUnicode'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
								{
			                		xtype: 'radiogroup'
									,name: 'convertFromUTF7'
									,id: 'convertFromUTF7'
									,fieldLabel: 'Converts UTF7 Chars to UTF8 Chars'
									,width: 200
									,defaults:{xtype:'radio',name:'convertFromUTF7'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
								{
			                		xtype: 'radiogroup'
									,name: 'convertFromConcatenated'
									,id: 'convertFromConcatenated'
									,fieldLabel: 'Converts basic concatenations'
									,width: 200
									,defaults:{xtype:'radio',name:'convertFromConcatenated'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
								{
					               		xtype: 'radiogroup'
										,name: 'convertFromProprietaryEncodings'
										,id: 'convertFromProprietaryEncodings'
										,fieldLabel: 'Converts proprietary encoding types'
										,width: 200
										,defaults:{xtype:'radio',name:'convertFromProprietaryEncodings'}
										,items:[
											{boxLabel: 'Yes', inputValue: 1}
											,{boxLabel: 'No', inputValue: 0}
										]
								}
							]

					}]
				},
				{
					title: 'Layer 2 Filter Tweaks 1',
					autoHeight: true,
					labelWidth: 700,
					items:[
					{
							xtype:'fieldset',
							title: 'Layer 2 Filter Tweaks 1',
							labelAlign: 'left',
							items:[
   								 {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_1'
									,id: 'l2ruleid_1'
									,fieldLabel: '[ID 1] Finds html breaking injections including whitespace attacks'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_1'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_2'
									,id: 'l2ruleid_2'
									,fieldLabel: '[ID 2] Finds attribute breaking injections including whitespace attacks'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_2'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_3'
									,id: 'l2ruleid_3'
									,fieldLabel: '[ID 3] Finds unquoted attribute breaking injections'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_3'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_4'
									,id: 'l2ruleid_4'
									,fieldLabel: '[ID 4] Detects url-, name-, JSON, and referrer-contained payload attacks'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_4'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_5'
									,id: 'l2ruleid_5'
									,fieldLabel: '[ID 5] Detects hash-contained xss payload attacks, setter usage and property overloading'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_5'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_6'
									,id: 'l2ruleid_6'
									,fieldLabel: '[ID 6] Detects self contained xss via with(), common loops and regex to string conversion'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_6'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_7'
									,id: 'l2ruleid_7'
									,fieldLabel: '[ID 7] Detects JavaScript with(), ternary operators and XML predicate attacks'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_7'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_8'
									,id: 'l2ruleid_8'
									,fieldLabel: '[ID 8] Detects self-executing JavaScript functions'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_8'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_9'
									,id: 'l2ruleid_9'
									,fieldLabel: '[ID 9] Detects the IE octal, hex and unicode entities'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_9'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_10'
									,id: 'l2ruleid_10'
									,fieldLabel: '[ID 10] Detects basic directory traversal'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_10'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_11'
									,id: 'l2ruleid_11'
									,fieldLabel: '[ID 11] Detects specific directory and path traversal'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_11'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_12'
									,id: 'l2ruleid_12'
									,fieldLabel: '[ID 12] Detects etc/passwd inclusion attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_12'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_13'
									,id: 'l2ruleid_13'
									,fieldLabel: '[ID 13] Detects halfwidth/fullwidth encoded unicode HTML breaking attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_13'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_14'
									,id: 'l2ruleid_14'
									,fieldLabel: '[ID 14] Detects possible includes, VBSCript/JScript encodeed and packed functions'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_14'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_15'
									,id: 'l2ruleid_15'
									,fieldLabel: '[ID 15] Detects JavaScript DOM/miscellaneous properties and methods'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_15'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_16'
									,id: 'l2ruleid_16'
									,fieldLabel: '[ID 16] Detects possible includes and typical script methods'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_16'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_17'
									,id: 'l2ruleid_17'
									,fieldLabel: '[ID 17] Detects JavaScript object properties and methods'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_17'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_18'
									,id: 'l2ruleid_18'
									,fieldLabel: '[ID 18] Detects JavaScript array properties and methods'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_18'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_19'
									,id: 'l2ruleid_19'
									,fieldLabel: '[ID 19] Detects JavaScript string properties and methods'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_19'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_20'
									,id: 'l2ruleid_20'
									,fieldLabel: '[ID 20] Detects JavaScript language constructs'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_20'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_21'
									,id: 'l2ruleid_21'
									,fieldLabel: '[ID 21] Detects very basic XSS probings'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_21'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_22'
									,id: 'l2ruleid_22'
									,fieldLabel: '[ID 22] Detects advanced XSS probings via Script(), RexExp, constructors and XML namespaces'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_22'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_23'
									,id: 'l2ruleid_23'
									,fieldLabel: '[ID 23] Detects JavaScript location/document property access and window access obfuscation'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_23'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_24'
									,id: 'l2ruleid_24'
									,fieldLabel: '[ID 24] Detects basic obfuscated JavaScript script injections'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_24'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_25'
									,id: 'l2ruleid_25'
									,fieldLabel: '[ID 25] Detects obfuscated JavaScript script injections'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_25'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_26'
									,id: 'l2ruleid_26'
									,fieldLabel: '[ID 26] Detects JavaScript cookie stealing and redirection attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_26'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_27'
									,id: 'l2ruleid_27'
									,fieldLabel: '[ID 27] Detects data: URL injections, VBS injections and common URI schemes'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_27'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_28'
									,id: 'l2ruleid_28'
									,fieldLabel: '[ID 28] Detects IE firefoxurl injections, cache poisoning attempts and local file inclusion/execution'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_28'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_29'
									,id: 'l2ruleid_29'
									,fieldLabel: '[ID 29] Detects bindings and behavior injections'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_29'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_30'
									,id: 'l2ruleid_30'
									,fieldLabel: '[ID 30] Detects common XSS concatenation patterns 1/2'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_30'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_31'
									,id: 'l2ruleid_31'
									,fieldLabel: '[ID 31] Detects common XSS concatenation patterns 2/2'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_31'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_32'
									,id: 'l2ruleid_32'
									,fieldLabel: '[ID 32] Detects possible event handlers'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_32'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_33'
									,id: 'l2ruleid_33'
									,fieldLabel: '[ID 33] Detects obfuscated script tags and XML wrapped HTML'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_33'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_34'
									,id: 'l2ruleid_34'
									,fieldLabel: '[ID 34] Detects attributes in closing tags and conditional compilation tokens'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_34'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_35'
									,id: 'l2ruleid_35'
									,fieldLabel: '[ID 35] Detects common comment types'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_35'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    }
							]

					}]
				},
				{
					title: 'Layer 2 Filter Tweaks 2',
					labelAlign: 'left',
					autoHeight: true,
					labelWidth: 700,
					items:[
					{
							xtype:'fieldset',
							title: 'Layer 2 Filter Tweaks 2',
							items:[
   								 {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_36'
									,id: 'l2ruleid_36'
									,fieldLabel: '[ID 36] Finds malicious attribute injection attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_36'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_37'
									,id: 'l2ruleid_37'
									,fieldLabel: '[ID 37] Detects base href injections and XML entity injection'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_37'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_38'
									,id: 'l2ruleid_38'
									,fieldLabel: '[ID 38] Detects possibly malicious html elements including some attributes'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_38'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_39'
									,id: 'l2ruleid_39'
									,fieldLabel: '[ID 39] Detects nullbytes and other dangerous characters'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_39'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_40'
									,id: 'l2ruleid_40'
									,fieldLabel: '[ID 40] Detects MySQL comments, conditions and ch(a)r injections'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_40'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_41'
									,id: 'l2ruleid_41'
									,fieldLabel: '[ID 41] Detects conditional SQL injection attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_41'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_42'
									,id: 'l2ruleid_42'
									,fieldLabel: '[ID 42] Detects classic SQL injection probings 1/2'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_42'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_43'
									,id: 'l2ruleid_43'
									,fieldLabel: '[ID 43] Detects classic SQL injection probings 2/2'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_43'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_44'
									,id: 'l2ruleid_44'
									,fieldLabel: '[ID 44] Detects basic SQL authentication bypass attempts 1/3'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_44'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_45'
									,id: 'l2ruleid_45'
									,fieldLabel: '[ID 45] Detects basic SQL authentication bypass attempts 2/3'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_45'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_46'
									,id: 'l2ruleid_46'
									,fieldLabel: '[ID 46] Detects basic SQL authentication bypass attempts 3/3'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_46'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_47'
									,id: 'l2ruleid_47'
									,fieldLabel: '[ID 47] Detects concatenated basic SQL injection and SQLLFI attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_47'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_48'
									,id: 'l2ruleid_48'
									,fieldLabel: '[ID 48] Detects chained SQL injection attempts 1/2'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_48'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_49'
									,id: 'l2ruleid_49'
									,fieldLabel: '[ID 49] Detects chained SQL injection attempts 2/2'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_49'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_50'
									,id: 'l2ruleid_50'
									,fieldLabel: '[ID 50] Detects SQL benchmark and sleep injection attempts including conditional queries'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_50'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_51'
									,id: 'l2ruleid_51'
									,fieldLabel: '[ID 51] Detects MySQL UDF injection and other data/structure manipulation attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_51'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_52'
									,id: 'l2ruleid_52'
									,fieldLabel: '[ID 52] Detects MySQL charset switch and MSSQL DoS attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_52'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_53'
									,id: 'l2ruleid_53'
									,fieldLabel: '[ID 53] Detects MySQL and PostgreSQL stored procedure/function injections'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_53'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_54'
									,id: 'l2ruleid_54'
									,fieldLabel: '[ID 54] Detects Postgres pg_sleep injection, waitfor delay attacks and database shutdown attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_54'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_55'
									,id: 'l2ruleid_55'
									,fieldLabel: '[ID 55] Detects MSSQL code execution and information gathering attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_55'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_56'
									,id: 'l2ruleid_56'
									,fieldLabel: '[ID 56] Detects MATCH AGAINST, MERGE, EXECUTE IMMEDIATE and HAVING injections'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_56'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_57'
									,id: 'l2ruleid_57'
									,fieldLabel: '[ID 57] Detects MySQL comment-/space-obfuscated injections'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_57'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_58'
									,id: 'l2ruleid_58'
									,fieldLabel: '[ID 58] Detects code injection attempts 1/3'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_58'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_59'
									,id: 'l2ruleid_59'
									,fieldLabel: '[ID 59] Detects code injection attempts 2/3'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_59'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_60'
									,id: 'l2ruleid_60'
									,fieldLabel: '[ID 60] Detects code injection attempts 3/3'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_60'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_61'
									,id: 'l2ruleid_61'
									,fieldLabel: '[ID 61] Detects url injections and RFE attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_61'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_62'
									,id: 'l2ruleid_62'
									,fieldLabel: '[ID 62] Detects common function declarations and special JS operators'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_62'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_63'
									,id: 'l2ruleid_63'
									,fieldLabel: '[ID 63] Detects common mail header injections'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_63'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_64'
									,id: 'l2ruleid_64'
									,fieldLabel: '[ID 64] Detects perl echo shellcode injection and LDAP vectors'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_64'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_65'
									,id: 'l2ruleid_65'
									,fieldLabel: '[ID 65] Detects basic XSS DoS attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_65'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_66'
									,id: 'l2ruleid_66'
									,fieldLabel: '[ID 66] Detects unknown attack vectors based on PHPIDS Centrifuge detection'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_66'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_67'
									,id: 'l2ruleid_67'
									,fieldLabel: '[ID 67] Finds attribute breaking injections including obfuscated attributes'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_67'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_68'
									,id: 'l2ruleid_68'
									,fieldLabel: '[ID 68] Finds basic VBScript injection attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_68'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_69'
									,id: 'l2ruleid_69'
									,fieldLabel: '[ID 69] Finds basic MongoDB SQL injection attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_69'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    },
							    {
			                		xtype: 'radiogroup'
									,name: 'l2ruleid_70'
									,id: 'l2ruleid_70'
									,fieldLabel: '[ID 70] Finds SQL injection attempts'
									,width: 200
									,defaults:{xtype:'radio',name:'l2ruleid_70'}
									,items:[
										{boxLabel: 'Yes', inputValue: 1,checked:true}
										,{boxLabel: 'No', inputValue: 0}
									]
							    }
							]

					}]
				},
				{
					title: 'Addon Scanning Setting',
					labelAlign: 'left',
					autoHeight: true,
					labelWidth: 200,
					items:[
					{
						xtype:'fieldset',
						title: 'Anti-Flooding',
						items:[
						{
		                		xtype: 'radiogroup'
								,name: 'antiflooding'
								,id: 'antiflooding'
								,fieldLabel: 'Enable Anti-Flooding'
								,width: 200
								,defaults:{xtype:'radio',name:'antiflooding'}
								,items:[
									{boxLabel: 'Yes', inputValue: 1}
									,{boxLabel: 'No', inputValue: 0, checked:true}
								]
						},
						{
				                xtype:'textfield',
				                fieldLabel: 'Detection Duration (in seconds)',
				                name: 'decduration',
				                id: 'decduration',
				                size: 100,
				                emptyText: 10
				       	},
						{
		                		xtype:'textfield',
				                fieldLabel: 'Maximum visits during detection',
				                name: 'maxvisits',
				                id: 'maxvisits',
				                size: 100,
				                emptyText: 5
						}
						]
					      }
					  ]
			},{
					title: 'Advanced Scanning Setting',
					labelAlign: 'left',
					autoHeight: true,
					labelWidth: 200,
					items:[
					{
						xtype:'fieldset',
						title: 'Layer 2 Scanning Tweaks',
						items:[
						{
							fieldLabel: 'Tips',
						    width: 900,
						    border: false,
							html:'<div style:"padding: 5px; font-size: 12px;"> The following functions are for advanced users only, please do not use these function unless you understand the theory behind it.</div>'
						}
						,
						{
		                		xtype: 'radiogroup'
								,name: 'scankey'
								,id: 'scankey'
								,fieldLabel: 'Scan Variable Keys in Layer 2 protection'
								,width: 200
								,defaults:{xtype:'radio',name:'scankey'}
								,items:[
									{boxLabel: 'Yes', inputValue: 1}
									,{boxLabel: 'No', inputValue: 0, checked:true}
								]
						},
						{
				                xtype:'textfield',
				                fieldLabel: 'Maximum Variable Key Length',
				                name: 'scankeyLength',
				                id: 'scankeyLength',
				                size: 100,
				                emptyText: 50
				       	},
						{
		                		xtype: 'radiogroup'
								,name: 'scancookies'
								,id: 'scancookies'
								,fieldLabel: 'Scan Cookies in Layer 2 protection'
								,width: 200
								,defaults:{xtype:'radio',name:'scancookies'}
								,items:[
									{boxLabel: 'Yes', inputValue: 1}
									,{boxLabel: 'No', inputValue: 0, checked:true}
								]
						}
						,
						{
			               		xtype: 'radiogroup'
								,name: 'convertFromSQLKeywords'
								,id: 'convertFromSQLKeywords'
								,fieldLabel: 'Converts basic SQL keywords and obfuscations'
								,width: 200
								,hidden: true
								,defaults:{xtype:'radio',name:'convertFromSQLKeywords'}
								,items:[
									{boxLabel: 'Yes', inputValue: 1}
									,{boxLabel: 'No', inputValue: 0, checked:true}
								]
						},
						{
		                		xtype: 'radiogroup'
								,name: 'runCentrifuge'
								,id: 'runCentrifuge'
								,fieldLabel: 'Run the Centrifuge function'
								,width: 200
								,defaults:{xtype:'radio',name:'runCentrifuge'}
								,items:[
									{boxLabel: 'Yes', inputValue: 1}
									,{boxLabel: 'No', inputValue: 0, checked:true}
								]
						}
						]
					      }
					  ]
			}
    		]
		}
		],

        buttons: [{
            text: 'Save',
            handler: function (){
            	var adminEmail = Ext.get('adminEmail').dom.value;
            	if (adminEmail=='')
            	{
            		Ext.Msg.alert('ERROR', 'Please enter an administrator email in the SEO section.');
            		return false;
            	}
				top.getForm().submit({
							url : 'index.php' ,
							params : {
								option : 'com_ose_antihacker',
								task:'saveConfiguration',
								controller:'antihacker',
								threshold: thresholdSlider.getValues()
							},
							method: 'POST',
							success: function ( form,action ) {
								//alert(action.result.result);
								msg = action.result;
								if (msg.status!='ERROR')
								{
									Ext.Msg.alert(msg.status, msg.result);
									top.load({
										url : 'index.php' ,
										params : {
										option : 'com_ose_antihacker',
										task:'getConfiguration',
										controller:'antihacker'
										},
										method: 'POST',
										success: function (form, action ) {
											thresholdSlider.setValue(action.result.data.threshold);
											//Ext.fly('curSecLevel').update(action.result.data.threshold);
										}
									});
								}
								else
								{
									Ext.Msg.alert('Error', msg.result);
									top.render();
								}
							}
				});
            }
        }],
        reader: new Ext.data.JsonReader({
		    root: 'result',
		    totalProperty: 'total',
		    idProperty: "id",
		    fields:[
		        {name: 'id', type: 'int', mapping: 'id'},
			    {name: 'pageTitle', type: 'string', mapping: 'pageTitle'},
			    {name: 'metaKeywords', type: 'string', mapping: 'metaKeywords'},
			    {name: 'metaDescription', type: 'string', mapping: 'metaDescription'},
			    {name: 'metaGenerator', type: 'string', mapping: 'metaGenerator'},
			    {name: 'customBanpage', type: 'string', mapping: 'customBanpage'},
			    {name: 'threshold', type: 'string', mapping: 'threshold'},
			    {name: 'scankey', type: 'int', mapping: 'scankey'},
			    {name: 'scankeyLength', type: 'int', mapping: 'scankeyLength'},
			    {name: 'runCentrifuge', type: 'int', mapping: 'runCentrifuge'},
			    {name: 'blockIP', type: 'int', mapping: 'blockIP'},
			    {name: 'scancookies', type: 'int', mapping: 'scancookies'},
			    {name: 'allowExts', type: 'string', mapping: 'allowExts'},
			    {name: 'adminEmail', type: 'string', mapping: 'adminEmail'},
			    {name: 'scanFileVirus', type: 'string', mapping: 'scanFileVirus'},
			    {name: 'convertFromRepetition', type: 'int', mapping: 'convertFromRepetition'},
			    {name: 'convertFromCommented', type: 'int', mapping: 'convertFromCommented'},
			    {name: 'convertFromWhiteSpace', type: 'int', mapping: 'convertFromWhiteSpace'},
			    {name: 'convertFromJSCharcode', type: 'int', mapping: 'convertFromJSCharcode'},
			    {name: 'convertJSRegexModifiers', type: 'int', mapping: 'convertJSRegexModifiers'},
			    {name: 'convertEntities', type: 'int', mapping: 'convertEntities'},
			    {name: 'convertQuotes', type: 'int', mapping: 'convertQuotes'},
			    {name: 'convertFromSQLHex', type: 'int', mapping: 'convertFromSQLHex'},
			    {name: 'convertFromSQLKeywords', type: 'int', mapping: 'convertFromSQLKeywords'},
			    {name: 'convertFromControlChars', type: 'int', mapping: 'convertFromControlChars'},
			    {name: 'convertFromNestedBase64', type: 'int', mapping: 'convertFromNestedBase64'},
			    {name: 'convertFromOutOfRangeChars', type: 'int', mapping: 'convertFromOutOfRangeChars'},
			    {name: 'convertFromXML', type: 'int', mapping: 'convertFromXML'},
			    {name: 'convertFromJSUnicode', type: 'int', mapping: 'convertFromJSUnicode'},
			    {name: 'convertFromUTF7', type: 'int', mapping: 'convertFromUTF7'},
			    {name: 'convertFromConcatenated', type: 'int', mapping: 'convertFromConcatenated'},
			    {name: 'convertFromProprietaryEncodings', type: 'int', mapping: 'convertFromProprietaryEncodings'},
			    {name: 'l2ruleid_1', type: 'int', mapping: 'l2ruleid_1'},
			    {name: 'l2ruleid_2', type: 'int', mapping: 'l2ruleid_2'},
			    {name: 'l2ruleid_3', type: 'int', mapping: 'l2ruleid_3'},
			    {name: 'l2ruleid_4', type: 'int', mapping: 'l2ruleid_4'},
			    {name: 'l2ruleid_5', type: 'int', mapping: 'l2ruleid_5'},
			    {name: 'l2ruleid_6', type: 'int', mapping: 'l2ruleid_6'},
			    {name: 'l2ruleid_7', type: 'int', mapping: 'l2ruleid_7'},
			    {name: 'l2ruleid_8', type: 'int', mapping: 'l2ruleid_8'},
			    {name: 'l2ruleid_9', type: 'int', mapping: 'l2ruleid_9'},
			    {name: 'l2ruleid_10', type: 'int', mapping: 'l2ruleid_10'},
			    {name: 'l2ruleid_11', type: 'int', mapping: 'l2ruleid_11'},
			    {name: 'l2ruleid_12', type: 'int', mapping: 'l2ruleid_12'},
			    {name: 'l2ruleid_13', type: 'int', mapping: 'l2ruleid_13'},
			    {name: 'l2ruleid_14', type: 'int', mapping: 'l2ruleid_14'},
			    {name: 'l2ruleid_15', type: 'int', mapping: 'l2ruleid_15'},
			    {name: 'l2ruleid_16', type: 'int', mapping: 'l2ruleid_16'},
			    {name: 'l2ruleid_17', type: 'int', mapping: 'l2ruleid_17'},
			    {name: 'l2ruleid_18', type: 'int', mapping: 'l2ruleid_18'},
			    {name: 'l2ruleid_19', type: 'int', mapping: 'l2ruleid_19'},
			    {name: 'l2ruleid_20', type: 'int', mapping: 'l2ruleid_20'},
			    {name: 'l2ruleid_21', type: 'int', mapping: 'l2ruleid_21'},
			    {name: 'l2ruleid_22', type: 'int', mapping: 'l2ruleid_22'},
			    {name: 'l2ruleid_23', type: 'int', mapping: 'l2ruleid_23'},
			    {name: 'l2ruleid_24', type: 'int', mapping: 'l2ruleid_24'},
			    {name: 'l2ruleid_25', type: 'int', mapping: 'l2ruleid_25'},
			    {name: 'l2ruleid_26', type: 'int', mapping: 'l2ruleid_26'},
			    {name: 'l2ruleid_27', type: 'int', mapping: 'l2ruleid_27'},
			    {name: 'l2ruleid_28', type: 'int', mapping: 'l2ruleid_28'},
			    {name: 'l2ruleid_29', type: 'int', mapping: 'l2ruleid_29'},
			    {name: 'l2ruleid_30', type: 'int', mapping: 'l2ruleid_30'},
			    {name: 'l2ruleid_31', type: 'int', mapping: 'l2ruleid_31'},
			    {name: 'l2ruleid_32', type: 'int', mapping: 'l2ruleid_32'},
			    {name: 'l2ruleid_33', type: 'int', mapping: 'l2ruleid_33'},
			    {name: 'l2ruleid_34', type: 'int', mapping: 'l2ruleid_34'},
			    {name: 'l2ruleid_35', type: 'int', mapping: 'l2ruleid_35'},
			    {name: 'l2ruleid_36', type: 'int', mapping: 'l2ruleid_36'},
			    {name: 'l2ruleid_37', type: 'int', mapping: 'l2ruleid_37'},
			    {name: 'l2ruleid_38', type: 'int', mapping: 'l2ruleid_38'},
			    {name: 'l2ruleid_39', type: 'int', mapping: 'l2ruleid_39'},
			    {name: 'l2ruleid_40', type: 'int', mapping: 'l2ruleid_40'},
			    {name: 'l2ruleid_41', type: 'int', mapping: 'l2ruleid_41'},
			    {name: 'l2ruleid_42', type: 'int', mapping: 'l2ruleid_42'},
			    {name: 'l2ruleid_43', type: 'int', mapping: 'l2ruleid_43'},
			    {name: 'l2ruleid_44', type: 'int', mapping: 'l2ruleid_44'},
			    {name: 'l2ruleid_45', type: 'int', mapping: 'l2ruleid_45'},
			    {name: 'l2ruleid_46', type: 'int', mapping: 'l2ruleid_46'},
			    {name: 'l2ruleid_47', type: 'int', mapping: 'l2ruleid_47'},
			    {name: 'l2ruleid_48', type: 'int', mapping: 'l2ruleid_48'},
			    {name: 'l2ruleid_49', type: 'int', mapping: 'l2ruleid_49'},
			    {name: 'l2ruleid_50', type: 'int', mapping: 'l2ruleid_50'},
			    {name: 'l2ruleid_51', type: 'int', mapping: 'l2ruleid_51'},
			    {name: 'l2ruleid_52', type: 'int', mapping: 'l2ruleid_52'},
			    {name: 'l2ruleid_53', type: 'int', mapping: 'l2ruleid_53'},
			    {name: 'l2ruleid_54', type: 'int', mapping: 'l2ruleid_54'},
			    {name: 'l2ruleid_55', type: 'int', mapping: 'l2ruleid_55'},
			    {name: 'l2ruleid_56', type: 'int', mapping: 'l2ruleid_56'},
			    {name: 'l2ruleid_57', type: 'int', mapping: 'l2ruleid_57'},
			    {name: 'l2ruleid_58', type: 'int', mapping: 'l2ruleid_58'},
			    {name: 'l2ruleid_59', type: 'int', mapping: 'l2ruleid_59'},
			    {name: 'l2ruleid_60', type: 'int', mapping: 'l2ruleid_60'},
			    {name: 'l2ruleid_61', type: 'int', mapping: 'l2ruleid_61'},
			    {name: 'l2ruleid_62', type: 'int', mapping: 'l2ruleid_62'},
			    {name: 'l2ruleid_63', type: 'int', mapping: 'l2ruleid_63'},
			    {name: 'l2ruleid_64', type: 'int', mapping: 'l2ruleid_64'},
			    {name: 'l2ruleid_65', type: 'int', mapping: 'l2ruleid_65'},
			    {name: 'l2ruleid_66', type: 'int', mapping: 'l2ruleid_66'},
			    {name: 'l2ruleid_67', type: 'int', mapping: 'l2ruleid_67'},
			    {name: 'l2ruleid_68', type: 'int', mapping: 'l2ruleid_68'},
			    {name: 'l2ruleid_69', type: 'int', mapping: 'l2ruleid_69'},
			    {name: 'l2ruleid_70', type: 'int', mapping: 'l2ruleid_70'},
			    {name: 'antiflooding', type: 'int', mapping: 'antiflooding'},
			    {name: 'decduration', type: 'int', mapping: 'decduration'},
			    {name: 'maxvisits', type: 'int', mapping: 'maxvisits'}

		  	]
	  	}),
	  	listeners: {
			render: function(p){
				p.getForm().load({
					url : 'index.php' ,
					params : {
					option : 'com_ose_antihacker',
					task:'getConfiguration',
					controller:'antihacker'
					},
					method: 'POST',
					success: function (form, action ) {
						thresholdSlider.setValue(action.result.data.threshold);
						//Ext.fly('curSecLevel').update(action.result.data.threshold);
					}
				});
			}
		}
    });
		panel = new Ext.Panel({
		id: 'oseATHConfig-panel'
		,border: false
		,layout: 'fit'
		,items:[
			top
		]
		,height: 650
		,width: '100%'
		,renderTo: 'customform'
	});
})
</script>