<?php 
/**
* GuardXT for Joomla!
* @Copyright ((c) 2009 JoomlaXT
* @ All rights reserved
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @ http://www.joomlaxt.com
* @version 1.00.04
**/
defined('_JEXEC') or die('Direct Access to this location is not allowed.');
?>


<?php
jimport( 'joomla.html.toolbar.button');


if (!function_exists('hash')) {
	function hash($code, $file) {
		$hash = md5($file);
		return $hash;		
	}
}

function xtHash($fullpath) {
	$txt = array("txt", "htm", "html", "php", "xml", "ini");
	$parts = pathinfo($fullpath);
	$filecontents = file_get_contents($fullpath);
	if (!isset($parts["extension"]) || in_array(strtolower($parts["extension"]), $txt)) {

		$hash = hash('md5', str_replace("\r\n", "\n", $filecontents));
	}
	else
		$hash = hash('md5', $filecontents);
	return $hash;	
}

function file_get_contents_utf8($fn) {
     $content = file_get_contents($fn);
      return mb_convert_encoding($content, 'UTF-8',
          mb_detect_encoding($content, 'UTF-8, ISO-8859-1', true));
} 

class xtUtils {
	function getFiles($path) {
		$c= new guardxtModelConfig();
		$exFolders = $c->getExFolders();
		// Initialize variables
		$arr = array ();
		$path = JPath::clean($path, "/");

		// read the source directory
		$handle = opendir($path);
		while (($file = readdir($handle)) !== false)
		{
			$dir = $path."/".$file;
			$isDir = is_dir($dir);

			if (($file != '.') && ($file != '..') && (!in_array($dir, $exFolders))) {
				if ($isDir) {
					$arr2 = xtUtils::getFiles($dir);
					$arr = array_merge($arr, $arr2);
				} 
				else {
					$arr[] = $path."/".$file;
				}
			}
//			elseif (($file != '.') && ($file != '..')) {echo $dir;print_r($exFolders);die;}
		}
		closedir($handle);

		asort($arr);
		return $arr;
	}

 	function getHelpButton($topic) {
 	 	$id = xtUtils::mapTopicId($topic);
 	 	$url = "http://www.joomlaxt.com/index.php?option=com_content&view=article&id=".$id;
		$html = guardXTButtonHelp::fetchButton($url);
	 	$bar = & JToolBar::getInstance('toolbar');
   		$bar->appendButton( 'custom', $html );
	}
	
	function mapTopicId($topic) {
	 	$t = array();
	 	$t['overview'] = '82';
	 	$t['authWizard'] = '83';
	 	$t['config'] = '84';
	 	$t['fileperm'] = '85';
	 	$t['folderperm'] = '85';
	 	$t['files'] = '86';
	 	$t['php'] = '87';
	 	$t['version'] = '88';
	 	$t['hash'] = '89';
	 	
	 	if (isset($t[$topic])) return $t[$topic];
	 	else return '81';
	 	
	}
}// class

class guardXTButtonHelp extends JButton {

	function fetchButton($url)
	{
		$text	= JText::_('Help');
		$class	= parent::fetchIconClass('help');
		$cmd = "popupWindow('$url', '".JText::_('Help', true)."', 640, 480, 1)";

		$html	= "<a href=\"#\" onclick=\"$cmd\" class=\"toolbar\">\n";
		$html .= "<span class=\"$class\" title=\"$text\">\n";
		$html .= "</span>\n";
 		$html	.= "$text\n";
		$html	.= "</a>\n";

		return $html;
	}

}
?>