<?php
defined('_JEXEC') or die(";)");

class oseConfig
{
	function load($app='msc',$config_type = null,$type = 'array')
	{
		$db = oseDB::instance();

		$where = array();

		if(!empty($config_type))
		{
			if(is_array($config_type))
			{
				$values = array();
				foreach($config_type as $configType)
				{
					$values[] = $db->Quote($configType);
				}

				$where[] = 'type IN ('.implode(',',$values).')';
			}
			else
			{
				$where[] = 'type='.$db->Quote($config_type);
			}


		}
		$where[] = '`app`='.$db->Quote($app);
		$where = oseDB::implodeWhere($where);

		$query = " SELECT * FROM `#__ose_app_config` "
				. $where
				;

		$db->setQuery($query);

		$objs = oseDB::loadList('obj');

		if($type == 'array')
		{
			$config = array();
		}
		else
		{
			$config = new stdClass();
		}

		foreach($objs as $obj)
		{
			$config = oseObject::setValue($config,$obj->key,$obj->value);
		}

		$config = oseObject::setValue($config,'id',1);

		return $config;
	}

	function save($app='msc',$config_type,$vals)
	{
		$db = oseDB::instance();
		$config = self::load($app,$config_type,'obj');
		$updated = true;
		foreach($vals as $k => $v)
		{
			if(!isset($config->{$k}))
			{
				$iVals = array();
				$iVals['app'] = $app;
				$iVals['type'] = $config_type;
				$iVals['key'] = $k;
				$iVals['value'] = $v;
				$updated = oseDB::insert('#__ose_app_config',$iVals);

				if(!$updated)
				{
					break;
				}
			}
			else
			{
				if($config->{$k} != $v)
				{
					$query = "UPDATE `#__ose_app_config`"
							." SET `value`=".$db->Quote($v)
							." WHERE `app` = '{$app}' AND `key`='{$k}'"
							;
					$db->setQuery($query);
					$updated = oseDB::query();

					if(!$updated)
					{
						break;
					}
				}
			}
		}

		return $updated;
	}

	function getAdminGroup($app)
	{
		$config = self::load($app,'','obj');

		if(oseObject :: getValue($config, 'admin_group', false) != false)
		{
			$mode= oseJson::decode($item->value);
		}
		else
		{
			$version= oseHTML :: getJoomlaVersion();
			if($version >= '1.6')
			{
				$mode= '[7,8]';
			}
			else
			{
				$mode= '[24,25]';
			}
			$mode= oseJson::decode($mode);
		}

		return $mode;
	}
}

class oseAppConfig
{
	function load($app,$config = array())
	{
		oseRegistry :: register('registry', 'oseregistry');
		oseRegistry :: call('registry');
		switch($app)
		{
			case('msc'):
				oseRegistry :: register('remote', 'remote');
				oseRegistry :: register('email', 'email');

				oseRegistry :: register('msc', 'membership');

				oseRegistry :: register('user', 'user');
				oseRegistry :: quickRequire('user');
				oseRegistry :: register('member', 'member'); // default

				oseRegistry :: register('payment', 'payment');
				oseRegistry :: quickRequire('payment');

				oseRegistry :: register('lic', 'license');
				oseRegistry :: register('content', 'content');
			break;

			case('credit'):
				oseAppConfig::load('payment');
				//oseRegistry :: register('user2', 'user2');
				//oseRegistry :: quickRequire('user2');
				//oseRegistry :: register('payment2', 'payment2');

				oseRegistry :: quickRequire('payment2');
				oseRegistry :: register('payment2', 'paymentCredit');
				oseRegistry :: register('credit', 'credit');
				oseRegistry :: register('content', 'content');
			break;

			case('commerce'):
			case('payment'):
				oseRegistry :: register('remote', 'remote');
				oseRegistry :: register('email', 'email');

				oseRegistry :: register('user2', 'user2');
				oseRegistry :: register('locale', 'locale');
				oseRegistry :: register('form', 'form');
				//oseRegistry :: quickRequire('user2');

				oseRegistry :: register('payment2', 'payment2');
				//oseRegistry :: quickRequire('payment2');
			break;

			case('license'):
				oseRegistry :: register('license', 'license2');
			break;
		}
	}
}
?>