<?php
/**
  * @version     3.0 +
  * @package       Open Source Excellence Security Suite
  * @subpackage    Open Source Excellence CPU
  * @author        Open Source Excellence {@link http://www.opensource-excellence.com}
  * @author        Created on 30-Sep-2010
  * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
  *
  *
  *  This program is free software: you can redistribute it and/or modify
  *  it under the terms of the GNU General Public License as published by
  *  the Free Software Foundation, either version 3 of the License, or
  *  (at your option) any later version.
  *
  *  This program is distributed in the hope that it will be useful,
  *  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *  GNU General Public License for more details.
  *
  *  You should have received a copy of the GNU General Public License
  *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  *  @Copyright Copyright (C) 2008 - 2010- ... Open Source Excellence
*/
defined('_JEXEC') or die("Direct Access Not Allowed");
?>
<script type="text/javascript" >
Ext.ns('oseATH','oseATHReportML');
oseATH.msg = new Ext.App();
function viewdetail(id)
{
	var win = new Ext.Window({
			id:'attackdetail',
			title: 'Attack information',
            layout:'fit',
            width:1024,
            height:500,
            closeAction:'close',
            closable:'true',
            collapsible:'true',
            autoScroll:'true'
	})

	Ext.Ajax.request({
				url : 'index.php' ,
				params : {
					option : 'com_ose_antihacker',
					task:'viewAttack',
					controller:'report',
					id: id
				},
				method: 'POST',
				success: function ( result, request ) {
					msg = Ext.decode(result.responseText);
					if (msg.status!='ERROR')
					{
						win.show();
						win.update(msg.result);
					}
					else
					{
						Ext.Msg.alert('ERROR');
					}
				}
		});
}

Ext.onReady(function(){
		oseATHReportML.cm = new Ext.grid.ColumnModel({
        defaults: {
            sortable: false
        },
        columns: [
            new Ext.grid.RowNumberer({header:'#'})
            ,{id: 'id', header: 'ID',  hidden:false, dataIndex: 'id', width: 20, sortable: true}
            ,{id: 'score', header: 'Risk Score',  hidden:false, dataIndex: 'score', sortable: true}
            ,{id: 'name', header: 'IP Rule Title',  hidden:false, dataIndex: 'name', sortable: true}
            ,{id: 'ip_start', header: 'Start IP',  hidden:false, dataIndex: 'ip_start', sortable: true}
            ,{id: 'ip_end', header: 'End IP',  hidden:false, dataIndex: 'ip_end', sortable: true}
            ,{id: 'iptype', header: 'IP Type',  hidden:false, dataIndex: 'iptype', sortable: true}
            ,{id: 'status', header: 'Status',  hidden:false, dataIndex: 'status', sortable: true}
            ,{id: 'host', header: 'Host',  hidden:false, dataIndex: 'host', sortable: true}
            ,{id: 'view', header: 'View Detail',  hidden:false, dataIndex: 'view', width: 20}
	    ],
	    sortInfo:{field: 'id', direction: "ASC"}
    });

		oseATHReportML.store = new Ext.data.Store({
		  proxy: new Ext.data.HttpProxy({
	            url: 'index.php?option=com_ose_antihacker&controller=report',
	            method: 'POST'
	      }),
		  baseParams:{task: "getMonitored",limit: 25},
		  reader: new Ext.data.JsonReader({
		    root: 'results',
		    totalProperty: 'total'
		  },[
		    {name: 'id', type: 'int', mapping: 'id'},
			{name: 'score', type: 'int', mapping: 'score'},
		    {name: 'name', type: 'string', mapping: 'name'},
		    {name: 'ip_start', type: 'string', mapping: 'ip_start'},
		    {name: 'ip_end', type: 'string', mapping: 'ip_end'},
		    {name: 'iptype', type: 'string', mapping: 'iptype'},
		    {name: 'status', type: 'string', mapping: 'status'},
		    {name: 'host', type: 'string', mapping: 'host'},
		    {name: 'view', type: 'string', mapping: 'view'}
		  ]),
		  autoLoad:{}
	});

    oseATHReportML.filters = new Ext.ux.grid.GridFilters({
        encode: true,
        local: false,
        filters: [ {
            type: 'list',
            dataIndex: 'Status',
            options: [[1,'Blacklisted'],[2,'Monitored'], [3,'Whitelisted']],
            phpMode: true
        }]
    });

	oseATH.oseATHReportML = new Ext.grid.GridPanel({
		id: 'oseATHReportML'
		,cm: oseATHReportML.cm
		,store: oseATHReportML.store
		,viewConfig: {forceFit: true}
		,plugins: [oseATHReportML.filters]
		,height: '500'
		,scroll: 'vertical'
		,width: 'auto'
		,region: 'west'
		,margins: {top:5, right:0, bottom:5, left:0}
		,tbar: new Ext.Toolbar({
			items: [
				    	{
				            id: 'addIPbutton',
				            text: 'Add an IP',
				            handler: function(){
								window.location = 'index.php?option=com_ose_antihacker&view=addips';
				            }
				        },{
				        	id: 'delSelected',
				            text: 'Delete Selected Items',
				            handler: function(){
				            	Ext.Msg.confirm('Delete confirmation', 'Please confirm that you would like to delete the selected items.', function(btn, text){
									if (btn == 'yes'){
										var sel = oseATH.oseATHReportML.getSelectionModel();
										var selections = sel.getSelections();
										athAjax('com_ose_antihacker','removeACL','report', selections);
							      	}
				            	})
				            }
				        },{
				        	id: 'blkSelected',
				            text: 'Move items to Blacklisted IPs',
				            handler: function(){
				            	Ext.Msg.confirm('Blacklist IPs confirmation', 'Please confirm that you would like to blacklist the selected items.', function(btn, text){
									if (btn == 'yes'){
										var sel = oseATH.oseATHReportML.getSelectionModel();
										var selections = sel.getSelections();
										athAjax('com_ose_antihacker','blacklistMonitored','report', selections);
							      	}
				            	})
				            }
				        },{
				        	id: 'whtSelected',
				            text: 'Move items to Whitelisted IPs',
				            handler: function(){
				            	Ext.Msg.confirm('Whitelist IPs confirmation', 'Please confirm that you would like to whitelist the selected items.', function(btn, text){
									if (btn == 'yes'){
										var sel = oseATH.oseATHReportML.getSelectionModel();
										var selections = sel.getSelections();
										athAjax('com_ose_antihacker','whitelistMonitored','report', selections);
							      	}
				            	})
				            }
				        },
				        '->','Search',
				        new Ext.ux.form.SearchField({
			                store: oseATHReportML.store,
			                paramName: 'search'
			            })
				    ]
		})
		,bbar:new Ext.PagingToolbar({
    		pageSize: 25,
    		store: oseATHReportML.store,
    		plugins: new Ext.ux.grid.limit({}),
    		displayInfo: true,
		    displayMsg: 'Displaying topics {0} - {1} of {2}',
		    emptyMsg: "No topics to display"

	    })
       });

	    oseATH.oseATHReportML.panel = new Ext.Panel({
		id: 'oseATHReportML-panel'
		,border: false
		,layout: 'fit'
		,items:[
			oseATH.oseATHReportML
		]
		,height: 'auto'
		,width: '100%'
		,renderTo: 'oseantihackerReport'
	});

function athAjax(option, task, controller,selections)
  {
	var i=0;
    ids=new Array();
	for (i=0; i < selections.length; i++)
	{
        ids [i] = selections[i].id;
	}
	ids = Ext.encode(ids);
	// Ajax post scanning request;
	Ext.Ajax.request({
				url : 'index.php' ,
				params : {
					option : option,
					task:task,
					controller:controller,
					ids: ids
				},
				method: 'POST',
				success: function ( result, request ) {
					msg = Ext.decode(result.responseText);
					if (msg.status!='ERROR')
					{
						oseATH.msg.setAlert(msg.status, 'The action '+task+' was executed successfully.');
						oseATHReportML.store.reload();
					}
					else
					{
						oseATH.msg.setAlert('Error', msg.result);
						oseATHReportML.store.reload();
					}
				}
			});
	}
})
</script>