<?php

/**
* @package		Mod_Accordionmenu
* @copyright	Copyright (C) 2008 James Frank
* @license		GNU/GPL

* This file was modified from the main Joomla mod_mainmenu file
* It is released under the same license

*/

// no direct access
defined('_JEXEC') or die('Restricted access');

if ($tagId = $params->get('tag_id')) {
	$menuid = $params->get('tag_id');
}
else {
	$menuid = "accordionMenu";
}

if ($params->get('show_images') == '1') {
	$expand_img = "modules/mod_accordionmenu/assets/plus.gif";
	$contract_img = "modules/mod_accordionmenu/assets/minus.gif";
}

?>

<script type="text/javascript">
	window.addEvent('domready', function(){
	accordionMenu(
		"<?php echo $menuid ?>", // Menu Tag ID (this id is assigned to menu parent ul tag)
		"<?php echo $expand_img ?>", //path to image used to expand menu item
		"<?php echo $contract_img ?>", //path to image used to collapse menu item
		{duration:<?php echo $params->get('duration_time'); ?>, transition:Fx.Transitions.Quart.easeOut}, // (optional argument) custom accordion options to override defaults, use null if you want to set next argument without changing this
		<?php echo $params->get('hover_time'); ?>, // (optional argument) hover delay in milliseconds over "parent menu item" to open its sublevels, default is 200
		<?php echo $params->get('activate_hovering'); ?> // (optional argument) enable/disable opening of submenus on hovering
	);
	
	});
</script>

<?php

if ( ! defined('modAccordionMenuXMLCallbackDefined') )
{
function modAccordionMenuXMLCallback(&$node, $args)
{
	$user	= &JFactory::getUser();
	$menu	= &JSite::getMenu();
	$active	= $menu->getActive();
	$path	= isset($active) ? array_reverse($active->tree) : null;

	if (($args['end']) && ($node->attributes('level') >= $args['end']))
	{
		$children = $node->children();
		foreach ($node->children() as $child)
		{
			if ($child->name() == 'ul') {
				$node->removeChild($child);
			}
		}
	}

	if ($node->name() == 'ul') {
		foreach ($node->children() as $child)
		{
			if ($child->attributes('access') > $user->get('aid', 0)) {
				$node->removeChild($child);
			}
		}
	}
	
	if (($node->name() == 'li') && isset($node->ul[0]->li)){
		
		
		
		$ul = $node->ul[0];
		$showUl = 1;
		foreach ($ul->children() as $child) {
			if ($child->attributes('access') <= $user->get('aid', 0)) {
				$showUl = 0;
			}
		}
		if ($showUl == 0) {		
			$node->addAttribute('class', 'parent');
		}
	}
	
	if (isset($path) && in_array($node->attributes('id'), $path))
	{
		if ($node->attributes('class')) {
			$node->addAttribute('class', $node->attributes('class').' active');
		} else {
			$node->addAttribute('class', 'active');
		}
	}
	else
	{
		if (isset($args['children']) && !$args['children'])
		{
			$children = $node->children();
			foreach ($node->children() as $child)
			{
				if ($child->name() == 'ul') {
					$node->removeChild($child);
				}
			}
		}
	}

	if (($node->name() == 'li') && ($id = $node->attributes('id'))) {
		if ($node->attributes('class')) {
			$node->addAttribute('class', $node->attributes('class').' item'.$id);
		} else {
			$node->addAttribute('class', 'item'.$id);
		}
	}

	if (isset($path) && $node->attributes('id') == $path[0]) {
		$node->addAttribute('id', 'current');
	} else {
		$node->removeAttribute('id');
	}
	$node->removeAttribute('level');
	$node->removeAttribute('access');
}
	define('modAccordionMenuXMLCallbackDefined', true);
}

modAccordionMenuHelper::render($params, 'modAccordionMenuXMLCallback');
