<?php
/**
*
* @package fabrikar
* @author Rob Clayburn
* @copyright (C) Rob Clayburn
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// Check to ensure this file is included in Joomla!

defined('_JEXEC') or die();

//require the abstract plugin class
require_once(COM_FABRIK_FRONTEND.DS.'models'.DS.'plugin.php');
require_once(COM_FABRIK_FRONTEND.DS.'models'.DS.'validation_rule.php');

class FabrikModelIsnot extends FabrikModelValidationRule {

	var $_pluginName = 'isnot';

	/** @param string classname used for formatting error messages generated by plugin */
	var $_className = 'notempty isnot';

	/**
	 * validate the elements data against the rule
	 * @param string data to check
	 * @param object element model
	 * @param int plugin sequence ref
	 * @param int repeat group count
	 * @return bol true if validation passes, false if fails
	 */

	function validate( $data, &$elementModel, $c, $repeat_count = 0 )
	{
		if (is_array($data)) {
			$data = implode('', $data);
		}
		$params =& $this->getParams();
		$isnot = $params->get('isnot-isnot', '_default','array', $c);
		$isnot = $isnot[$c];
		$isnot = explode('|', $isnot);
		foreach ($isnot as $i) {
			if($data == $i) {
				return false;
			}
		}
		return true;
	}
}
?>