<?php 
/**
* GuardXT for Joomla!
* @Copyright ((c) 2009 JoomlaXT
* @ All rights reserved
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @ http://www.joomlaxt.com
* @version 1.00.04
**/
defined('_JEXEC') or die('Direct Access to this location is not allowed.');
?>
<?php

JLoader::import('administrator.components.com_guardxt.models.log', JPATH_SITE);
JLoader::import('administrator.components.com_guardxt.models.files', JPATH_SITE);
JLoader::import('administrator.components.com_guardxt.models.config', JPATH_SITE);


function check($init="check", $rootpath=JPATH_SITE) {
	$db = JFactory::getDBO();

	$start = microtime(true);

// 	On initialization delete tables
	if ($init == "init") {
	 	echo date("H:i:s")." Initializing database.<br/>";
		$query = "TRUNCATE `#__guardxt_files`; \n";  
		$db->setQuery($query);
		$db->query();
		echo $db->getErrorMsg();
		$query = "TRUNCATE `#__guardxt_runs`;";  
		$db->setQuery($query);
		$db->query();
		echo $db->getErrorMsg();
	}
//	just for testing	
 	error_reporting(E_ALL);
 	ini_set("display_errors", "On");

 	echo date("H:i:s").": Initialize ".$init." run.<br/>";

// get the models
	$log= new guardxtModelLog();
	$fileModel = new guardxtModelFiles();
	$c= new guardxtModelConfig();

// get config
	$conf = $c->getData();
	$exFolders = $c->getExFolders();
	
// 	get hashfile for healthcheck
	$hashes = $fileModel->getHashFiles();
	$hashfilename = $fileModel->getHashFileName();
	
// 	get suspicious files
 	$sFile = file_get_contents(JPATH_COMPONENT_ADMINISTRATOR.DS."assets/textfiles/sfiles.txt");
 	$sFiles = explode(";",$sFile);

 	echo date("H:i:s").": Read filesystem.<br/>";
	//get all files
	$files = xtUtils::getFiles($rootpath);

 	echo date("H:i:s").": Read database.<br/>";
	// get the files from database
	$query = "SELECT * FROM #__guardxt_files WHERE type ='F' ";
	$db->setQuery($query);
	$rows = $db->loadObjectList();

 	
 	echo date("H:i:s").": ".count($files)." Files read.".count($rows)." Files in database.<br/>";
	
	$row = new guardxt_files($db);
	// loop at database
 	foreach ($rows as $r) {

		$ch = false;
		
		// fullpath with forward slashes (even on windows)
		$fullpath = JPATH::clean(JPATH_SITE.$r->path, "/");
		// if file dowsn't exist anymore delete from database
		if (!file_exists($fullpath)) {
			$query = "DELETE FROM #__guardxt_files WHERE id='$r->id'";
			$db->setQuery($query);
			$db->query();
			echo date("H:i:s").": Deleting non existing file...".$fullpath."<br/>";
			continue;
		}
		// if path was added to exclude folders - skip and delete
		$parts = pathinfo($fullpath);
		if (in_array($parts["dirname"], $exFolders) && $parts["dirname"] != JPATH_SITE) {
			$query = "DELETE FROM #__guardxt_files WHERE id='$r->id'";
			$db->setQuery($query);
			$db->query();
			echo date("H:i:s").": Deleting file from excluded path...".$fullpath."<br/>";
			continue;
		}		
		
		$mtime = filemtime($fullpath);
		$perms = substr(decoct(fileperms($fullpath)),3);
		if (filesize($fullpath) > ($conf->maxsize*1024) && $conf->maxsize > 0) {
			echo $r->path." skipped (".filesize($fullpath).")<br/>";
		$hash = 0;
		}
		else 
			$hash = xtHash($fullpath);

		// if DB-entry exists, with state
		// A(dded): Leave as is
		// M(odified): Check if modified time changed 
		// C(onfirmed): Check if modified time is not equal confirned time

		if (  ($mtime != $r->time AND $r->state == "C")       // confirmed file - date changed
			   OR ($mtime != $r->mtime AND $r->state == "M")  // modified file - date changed again
			   OR ($hash != $r->hash AND $r->state == "C")    // confirmed file - hash changed
			   OR ($hash != $r->mhash AND $r->state == "M")	// modified file - hash changed again
			   OR ($r->hcfile == "" AND $r->state == "M")		// healthcheck not yet performed 
			   OR ($r->hcfile != "" AND $r->hcfile != $hashfilename) // healthcheck performed with out-of-date-file
			){ 
			
			 
			echo date("H:i:s").": doing something... ".$r->path." <br/>";
//			//do healthcheck			
			if ($h = trim($fileModel->has_hash($r->path))) {
			echo date("H:i:s").": healthchecking... ".$r->path." <br/>";			 
			 	if ($h != $hash) {
					$row->state = "M"; 
					$row->healthcheck = "U";
					$row->hcfile = $hashfilename;
				}
				else {
					$row->state = "C";
					$row->healthcheck = "S";
					$row->hcfile = $hashfilename;	
					$row->hash = $hash;
					$row->time = $mtime;				
				}
			}
			else {
				$row->state = "M";
				$row->healthcheck = "";
				$row->hcfile = "";				
			}

			$row->id = $r->id;
			$row->mtime = $mtime; 
			$row->mhash = $hash;
			if ($row->state == "M") $log->add(stripslashes($r->path), "M", $mtime);
			$ch = true;			
		}
		if ($perms <> $r->fp ) {
			$row->id = $r->id;
			$row->fp = $perms; 
			$row->fpstate = "N";
			$log->add(stripslashes($r->path), "P", $mtime);
			$ch = true;
		}
		if ($ch) {
		 	$row->store(); 
		 	echo date("H:i:s")."storing something... ".$r->path." <br/>";
			
		}
		// remove file from filelist
		$id = array_search($fullpath,$files);
		unset($files[$id]);
	}
 	echo date("H:i:s").": Done checking database. ".count($files)." Files remaining.<br/>";


// only new files remaining	
	$bquery = array();
	$jpath_site = JPath::clean(JPATH_SITE, "/");		
	foreach ($files as $f) {
 		
		$row->id = false;
		// if suspicious file was added rename immediately
 	 	if (in_array(basename($f),$sFiles)) {
 			$p = $f."_guardxt";
 			rename($f,$p);
 			$f = $p;
 		}

		$mtime = filemtime($f);
		$perms = substr(decoct(fileperms($f)),3);
		if (filesize($f) > ($conf->maxsize*1024) && $conf->maxsize > 0) {
			echo $f." skipped (".filesize($f).")<br/>";
			$hash = 0;
		}
		else 
			$hash = xtHash($f);

		$shortpath = JPath::clean(str_replace($jpath_site, "", $f),"/");
		// if hash is o.k. then confirm
		if ($init=="init" && $conf->inithealth != 1) {
	 		if ($h = trim($fileModel->has_hash($shortpath))) {
			 	if ($h != $hash) {
					$row->state = "M"; 
					$row->healthcheck = "U";
					$row->hcfile = $hashfilename;	
				}
				else {
				 	$row->state = "C";
	 			 	$row->healthcheck = "S";
	 				$row->hcfile = $hashfilename;	
	 			}
	 		}
	 		else {
	 		 	if ($init=="check")
		 			$row->state = "A";
		 		else
		 			$row->state = "C";
		 		
				$row->healthcheck = "";
				$row->hcfile = "";
			}
		}
 		else {
 		 	if ($init=="check")
	 			$row->state = "A";
	 		else
	 			$row->state = "C";
	 		
			$row->healthcheck = "";
			$row->hcfile = "";
		}
		$row->path = $shortpath;
		if ($init=="init") $row->time=$mtime;
		$row->mtime = $mtime;
		$row->hash = $hash;
		$row->mhash = "";
		$row->type = "F";
		$row->fp = $perms; 
		$row->fpstate = "N";

		$bquery[] = "('','F','$row->path','$row->time','$row->mtime','$row->state','$row->fp','$row->fpstate','$row->hash','$row->mhash','$row->healthcheck','$row->hcfile')";
		$log->add($row->path, "A", $mtime);
	}
 	echo date("H:i:s").": Checking folders.<br/>";
		
	//check folders
	$folders = JFolder::folders($rootpath, "", true, true);
	$query = "SELECT * FROM #__guardxt_files WHERE type = 'D'";
	$db->setQuery($query);
	$rows = $db->loadObjectList();

 	echo date("H:i:s").": ".count($folders)." Folders read.".count($rows)." Folders in database.<br/>";
	$row = new guardxt_files($db);

 	foreach ($rows as $r) {
 	 	$rpath = JPath::clean($r->path, "/");
		if (!file_exists(JPATH_SITE.$r->path)) {
			$query = "DELETE FROM #__guardxt_files WHERE id='$r->id'";
			$db->setQuery($query);
			$db->query();
			continue;
		}
 	 
		$perms = substr(decoct(fileperms(JPATH_SITE.$r->path)),2);

		if ($perms <> $r->fp ) {
			$row->id = $r->id;
			$row->fp = $perms; 
			$row->fpstate = "N";
			$row->store();
			$log->add(stripslashes($r->path), "P", filemtime($f));
		}
		$id = array_search(JPath::clean(JPATH_SITE.$r->path, DS),$folders);
		unset($folders[$id]);
	}
	foreach ($folders as $f) {
	    	$row->id = false;
 			$perms = substr(decoct(fileperms($f)),2);
 			$mtime = filemtime($f);
			$f = JPath::clean(str_replace(JPATH_SITE, "", $f),"/");
			if ($init == "init") 
				$row->state = "C";
			else 
				$row->state = "A";
				
			$row->path = $f;
			$row->mtime = $mtime;
			$row->type = "D";
			$row->fp = $perms; 
			$row->fpstate = "N";
			$row->hash = "";
			$row->mhash = "";
			$row->healthcheck = "";
			$row->hcfile = "";
			$bquery[] = "('','D','$row->path','$row->time','$row->mtime','$row->state','$row->fp','$row->fpstate','$row->hash','$row->mhash','$row->healthcheck','$row->hcfile')";
			$log->add($row->path, "A", $mtime);
	}		

// store the big query
	if (count($bquery)>0) {
	 	echo date("H:i:s").": ".count($bquery)." inserts in 'big' query.<br/>";

		$q = "INSERT INTO `#__guardxt_files` (`id`, `type`, `path`, `time`, `mtime`, `state`, `fp`, `fpstate`, `hash`, `mhash`, `healthcheck`, `hcfile`) VALUES".implode(",\n", $bquery).";";
		$db->setQuery($q);
		$db->query();
		echo $db->getErrorMsg();
	}
// 	some statistics
 	echo date("H:i:s").": Done and goodbye.<br/>";

	if (function_exists('memory_get_peak_usage')) 
		echo 'Max memory usage: ' . number_format(memory_get_peak_usage(), 0, '.', ',') . " bytes<br/>";
	$end = microtime(true);
	$time = round($end-$start);
	echo "Execution time: ".$time." seconds<br/>";

	// add an entry to the log
	$row = new guardxt_runs($db);
	if ($init=="check")
		$row->type = "C";
	else 
		$row->type = "I";
	$row->log = $log->get();
	$row->time = time();	
	$row->store();

	return $log;
}



?>