var PluginManager = new Class({
	
	initialize:function(plugins, lang) {
		this.plugins = plugins;
		this.counter = 0;
		this.translate = {};
		$extend(this.translate, lang);
		this.opts = this.opts || {};
		this.deletePluginClick = this.deletePlugin.bindAsEventListener(this);
	},

	_makeSel: function(c, name, pairs, sel) {
		var opts = [];
		opts.push(new Element('option', {'value':''}).appendText(this.translate.please_select));
		pairs.each(function(pair) {
			var v = pair.value ? pair.value : pair.name; //plugin list should be keyed on plugin name 
			if(v == sel) {
				opts.push(new Element('option', {'value':v, 'selected':'selected'}).appendText(pair.label));
			}else{
				opts.push(new Element('option', {'value':v}).appendText(pair.label));
			}
		});
		return new Element('select', {'class':c,'name':name}).adopt(opts);
	},
	
	addPlugin: function(o) {
		this.plugins.push(o);
	},
	
	deletePlugin: function(e) {
		e = new Event(e);
		e.stop();
		$(e.target).up(3).remove();
		this.counter --;
	},
	
	watchAdd: function() {
		$('addPlugin').addEvent('click', function(e) {
			new Event(e).stop();
			this.addAction('', '', '', '');
		}.bind(this));
	},
	
	watchDelete: function() {
		$('plugins').getElements('.delete').each(function(c) {
			c.removeEvents('click');
			c.addEvent('click', this.deletePluginClick);
		}.bind(this));
	},
	
	getPluginTop:function() {
		return '';
	},
	
	addAction: function(pluginHTML, plugin, loc, when, cloneJs) {
		cloneJs = cloneJs === false ? false : true;
		var td = new Element('td');
		var str  = '';
		this.plugins.each(function(aPlugin) {
			if(aPlugin['name'] == plugin) {
				str += pluginHTML;
			}else{
				str += aPlugin.options.html;
			}
			
		}.bind(this));
		//test for settting radio buttons ids - seems to work
		str = str.replace(/\[0\]/gi, '[' + this.counter + ']');
		//end test
		td.innerHTML = str;
		var display =  'block';
		
		var cid = 'plugin-'+plugin+'-'+this.counter;
			var c = new Element('div', {id:cid, 'class':'actionContainer'}).adopt(
			new Element('table', {'class':'adminform','id':'formAction_' + this.counter, 'styles':{'display':display}}).adopt(
			new Element('tbody', {'styles':{'width':'100%'}}).adopt(
				[
				 this.getPluginTop(plugin, loc, when),
					new Element('tr').adopt(
					[
						td
					]),
					new Element('tr').adopt(
						new Element('td', {}).adopt(
							new Element('a', {'href':'#', 'class':'delete removeButton'
							}).appendText(this.translate.del)
						)
					)
				]
			))
		);
		
		c.injectInside($('plugins'));
		//update params ids
		if(this.counter != 0) {
			c.getElements('input[name^=params],select[name^=params]').each(function(i) {
				if(i.id !== '') {
					var a = i.id.split('-');
					a.pop();
					i.id = a.join('-') + '-' + this.counter;
				}
			}.bind(this));
			
			c.getElements('img[src=components/com_fabrik/images/ajax-loader.gif]').each(function(i) {
				i.id = i.id.replace('-0_loader', '-'+this.counter+'_loader');
			}.bind(this));
			if(cloneJs === true) {
				this.plugins.each(function(plugin) {
					// clone js controller
					var newPlugin = new CloneObject(plugin, true, []);
					newPlugin.cloned(this.counter);
				}.bind(this));
			}
		}
		var myTips = (function() {new Tips($$('#' + cid +' .hasTip'),{id:cid})}).delay(10000);
		// show the active plugin 
		var formaction = $('formAction_' + this.counter);
		var activePlugin = formaction.getElement(' .page-' + plugin);
		if(activePlugin) {
			activePlugin.setStyle('display','block');	
		}
		
		//watch the drop down
		formaction.getElement('.elementtype').addEvent('change', function(e) {
			e = new Event(e);
			var id = $(e.target).up(3).id.replace('formAction_', '');
			$$('#formAction_' + id + ' .elementSettings').each(function(d) {
				d.style.display = 'none'; 
			});
			var s = $(e.target).get('value');
			if(s != this.translate.please_select) {
				$('formAction_' + id).getElement('.page-' + s).style.display ='block';
			}
			e.stop();
		}.bind(this));
		this.watchDelete();
		
		//show any tips (only running code over newly added html)
		//var myTips = new Tips($$('#formAction_' + this.counter+' .hasTip'),{});
		
		
		this.counter ++;
	}
	
});

fabrikAdminPlugin = new Class({
	
	initialize:function(name, label, options)
	{
		this.name = name;
		this.label = label;
		this.options = {};
		$extend(this.options, options);
	},
	
	cloned:function() {
		
	}
		
});