var fabriktablesElement = new Class({
	
	initialize: function(el, options) {
		this.el = el;
		this.elements = [];
		this.elementLists = $H({}); //keyed on specific element options
		this.waitingElements = $H({}); //keyed on specific element options
		this.options = {
			conn:null,
			connInRepeat:true
		};
		$extend(this.options, options);
		//if loading in a form plugin then the connect is not yet avaiable in the dom
		if($type($(this.options.conn)) === false) {
			this.periodical = this.getCnn.periodical(500, this);
		}else{
			this.setUp();
		}
	},
	
	getCnn:function() {
		if($type($(this.options.conn)) === false) {
			return;
		}
		this.setUp();
		$clear(this.periodical);
	},
	
	registerElement:function(el) {
		this.elements.push(el);
	},
	
	setUp:function() {
		this.el = $(this.el);
		$(this.options.conn).addEvent('change', this.updateMe.bindAsEventListener(this));
		this.el.addEvent('change', this.updateElements.bindAsEventListener(this));
		//see if there is a connection selected
		var v = $(this.options.conn).get('value');
		if(v != '' && v != -1) {
			this.updateMe();
		}
	},
	
	updateMe: function(e) {
		if(e) {
			new Event(e).stop();
		}
		var cid = $(this.options.conn).get('value');
		//keep repeating the perioical untill the cnn drop down is completed
		if(!cid) {
			return;
		}
		if($(this.el.id+'_loader')) {
			$(this.el.id+'_loader').setStyle('display','inline');
		}
		var url = this.options.livesite + 'index.php?option=com_fabrik&format=raw&controller=plugin&task=pluginAjax&g=visualization&plugin=chart&method=ajax_tables&showf=1&cid=' + cid;
		var myAjax = new Ajax(url, { method:'get', 
			onComplete: function(r) {
				var opts = eval(r);
				if($type(opts) !== false) {
					this.el.empty();
					opts.each( function(opt) {
						//var o = {'value':opt.value};//wrong for calendar
						var o = {'value':opt.id};
						if(opt.id == this.options.value) {
							o.selected = 'selected';
						}
						new Element('option', o).appendText(opt.label).injectInside(this.el);
					}.bind(this));
					if($(this.el.id+'_loader')) {
							$(this.el.id+'_loader').setStyle('display','none');
						}
					this.updateElements();
				}
			}.bind(this)
		}).request();
	},
	
	updateElements:function()
	{
		this.elements.each(function(element) {
			var opts = element.getOpts();
			var table = this.el.get('value');
			if(table === '') {
				// $$$ rob dont empty as this messes up parameter saving in paypal plugin
				//element.el.empty();
				return;
			}
			if($(element.el.id+'_loader')) {
				$(element.el.id+'_loader').setStyle('display','');
			}
			var key = opts.values().toString() +','+ table;
			if(!this.waitingElements.hasKey(key)) {
				this.waitingElements.set(key, $H({}));
			}
			if(this.elementLists.hasKey(key)) {
				if(this.elementLists.get(key) == '') {
					//delay update 
					this.waitingElements.get(key).set(element.el.id, element);
				}else{
					//keyed on specific element options
					this.updateElementOptions(this.elementLists.get(key), element);
				}
			}else{
				
				var cid = $(this.options.conn).get('value');
				this.elementLists.set(key, '');
				var url = this.options.livesite + 'index.php?option=com_fabrik&format=raw&controller=plugin&task=pluginAjax&g=visualization&plugin=chart&method=ajax_fields&k=2&t=' + table + '&cid=' + cid;
				
				var ajaxopts = {};
				opts.each(function(v, k) {ajaxopts[k] = v;});
				var myAjax = new Ajax(url, { method:'get',
					'data':ajaxopts, 
					onComplete: function(r) {
						this.elementLists.set(key, r);
						this.updateElementOptions(r, element);
						this.waitingElements.get(key).each(function(el, i) {
							this.updateElementOptions(r, el);
							this.waitingElements.get(key).remove(i);
						}.bind(this));
					}.bind(this)
				}).request();
			}
		}.bind(this));
	},
	
	updateElementOptions:function(r, element) {
		var table = this.el.get('value');
		var key = element.getOpts().values().toString() + ','+table;
		var opts = eval(r);
		element.el.empty();
		var o = {'value':''};
		if(element.options.value == '') {
			o.selected = 'selected';
		}
		new Element('option', o).appendText('-').injectInside(element.el);
		opts.each( function(opt) {
			opt.value = opt.value.replace('[]', '');
			var o = {'value':opt.value};
			if(opt.value == element.options.value) {
				o.selected = 'selected';
			}
			new Element('option', o).appendText(opt.label).injectInside(element.el);
		}.bind(this));
		if($(element.el.id+'_loader')) {
			$(element.el.id+'_loader').setStyle('display','none');
		}
	},
	//only called from repeat viz admin interface i think
	cloned:function(newid, counter)
	{
		if(this.options.connInRepeat == true) {
			//table needs to update watch connection id
			var cid = this.options.conn.split('-');
			cid.pop();
			this.options.conn = cid.join('-') + '-' + counter;
		}
		this.el = newid;
		this.elements = [];
		this.elementLists = $H({});
		this.waitingElements = $H({});
		this.setUp();
		tableElements.set(this.el.id, this);
	}
		
});